/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import org.xiph.speex.Bits;
import org.xiph.speex.Decoder;
import org.xiph.speex.Filters;
import org.xiph.speex.Lsp;
import org.xiph.speex.ModesWB;
import org.xiph.speex.NbDecoder;
import org.xiph.speex.QmfTables;
import org.xiph.speex.SubMode;

public class WbDecoder
extends Decoder
implements QmfTables {
    protected Decoder lowdec;
    private int full_frame_size;
    private int frame_size;
    private int subframeSize;
    private int nbSubframes;
    private int lpcSize;
    private int first;
    private float folding_gain;
    private float[] x0d;
    private float[] high;
    private float[] y0;
    private float[] y1;
    private float[] g0_mem;
    private float[] g1_mem;
    private float[] exc;
    private float[] qlsp;
    private float[] old_qlsp;
    private float[] interp_qlsp;
    private float[] interp_qlpc;
    private float[] mem_sp;
    private float[] pi_gain;
    private float[] awk1;
    private float[] awk2;
    private float[] awk3;
    private float[] innov2;
    private SubMode[] submodes;
    private int submodeID;

    public void init() {
        this.lowdec = new NbDecoder();
        this.sbinit(160, 40, 8, 640, ModesWB.wbsubmodes, 3, 0.7f);
    }

    protected void sbinit(int n, int n2, int n3, int n4, SubMode[] subModeArray, int n5, float f) {
        this.lowdec.init();
        this.full_frame_size = 2 * n;
        this.frame_size = n;
        this.subframeSize = n2;
        this.nbSubframes = n / n2;
        this.lpcSize = 8;
        this.folding_gain = f;
        this.submodes = subModeArray;
        this.submodeID = n5;
        this.first = 1;
        this.x0d = new float[this.frame_size];
        this.high = new float[this.full_frame_size];
        this.y0 = new float[this.full_frame_size];
        this.y1 = new float[this.full_frame_size];
        this.g0_mem = new float[64];
        this.g1_mem = new float[64];
        this.exc = new float[this.frame_size];
        this.qlsp = new float[this.lpcSize];
        this.old_qlsp = new float[this.lpcSize];
        this.interp_qlsp = new float[this.lpcSize];
        this.interp_qlpc = new float[this.lpcSize + 1];
        this.pi_gain = new float[this.nbSubframes];
        this.mem_sp = new float[2 * this.lpcSize];
        this.awk1 = new float[9];
        this.awk2 = new float[9];
        this.awk3 = new float[9];
        this.innov2 = new float[this.subframeSize];
    }

    public int decode(Bits bits, float[] fArray) {
        int n;
        int n2 = this.lowdec.decode(bits, this.x0d);
        if (n2 != 0) {
            return n2;
        }
        int n3 = bits.peek();
        if (n3 != 0) {
            n3 = bits.unpack(1);
            this.submodeID = bits.unpack(3);
        } else {
            this.submodeID = 0;
        }
        for (n = 0; n < this.frame_size; ++n) {
            this.exc[n] = 0.0f;
        }
        if (this.submodes[this.submodeID] == null) {
            for (n = 0; n < this.frame_size; ++n) {
                this.exc[n] = 0.0f;
            }
            this.first = 1;
            Filters.iir_mem2(this.exc, 0, this.interp_qlpc, this.high, 0, this.frame_size, this.lpcSize, this.mem_sp);
            this.filters.fir_mem_up(this.x0d, h0, this.y0, this.full_frame_size, 64, this.g0_mem);
            this.filters.fir_mem_up(this.high, h1, this.y1, this.full_frame_size, 64, this.g1_mem);
            for (n = 0; n < this.full_frame_size; ++n) {
                fArray[n] = 2.0f * (this.y0[n] - this.y1[n]);
            }
            return 0;
        }
        float[] fArray2 = this.lowdec.getPiGain();
        float[] fArray3 = this.lowdec.getExc();
        float[] fArray4 = this.lowdec.getInnov();
        this.submodes[this.submodeID].lsqQuant.unquant(this.qlsp, this.lpcSize, bits);
        if (this.first != 0) {
            for (n = 0; n < this.lpcSize; ++n) {
                this.old_qlsp[n] = this.qlsp[n];
            }
        }
        for (int i = 0; i < this.nbSubframes; ++i) {
            float f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            int n4 = this.subframeSize * i;
            float f5 = (1.0f + (float)i) / (float)this.nbSubframes;
            for (n = 0; n < this.lpcSize; ++n) {
                this.interp_qlsp[n] = (1.0f - f5) * this.old_qlsp[n] + f5 * this.qlsp[n];
            }
            for (n = 0; n < this.lpcSize; ++n) {
                this.interp_qlsp[n] = (float)Math.cos(this.interp_qlsp[n]);
            }
            Lsp.enforce_margin(this.interp_qlsp, this.lpcSize, 0.002f);
            this.m_lsp.lsp2lpc(this.interp_qlsp, this.interp_qlpc, this.lpcSize);
            float f6 = 0.9f;
            float f7 = this.submodes[this.submodeID].lpc_enh_k1;
            float f8 = this.submodes[this.submodeID].lpc_enh_k2;
            float f9 = f7 - f8;
            Filters.bw_lpc(f7, this.interp_qlpc, this.awk1, this.lpcSize);
            Filters.bw_lpc(f8, this.interp_qlpc, this.awk2, this.lpcSize);
            Filters.bw_lpc(f9, this.interp_qlpc, this.awk3, this.lpcSize);
            f5 = 1.0f;
            this.pi_gain[i] = 0.0f;
            for (n = 0; n <= this.lpcSize; ++n) {
                f4 += f5 * this.interp_qlpc[n];
                f5 = -f5;
                int n5 = i;
                this.pi_gain[n5] = this.pi_gain[n5] + this.interp_qlpc[n];
            }
            f3 = fArray2[i];
            f3 = 1.0f / (Math.abs(f3) + 0.01f);
            f4 = 1.0f / (Math.abs(f4) + 0.01f);
            float f10 = Math.abs(0.01f + f4) / (0.01f + Math.abs(f3));
            for (n = n4; n < n4 + this.subframeSize; ++n) {
                this.exc[n] = 0.0f;
            }
            if (this.submodes[this.submodeID].innovation == null) {
                int n6 = bits.unpack(5);
                f = (float)Math.exp(((double)n6 - 10.0) / 8.0);
                f /= f10;
                for (n = n4; n < n4 + this.subframeSize; ++n) {
                    this.exc[n] = this.folding_gain * f * fArray4[n];
                }
            } else {
                int n7 = bits.unpack(4);
                for (n = n4; n < n4 + this.subframeSize; ++n) {
                    f2 += fArray3[n] * fArray3[n];
                }
                f = (float)Math.exp(0.27027026f * (float)n7 - 2.0f);
                float f11 = f * (float)Math.sqrt(1.0f + f2) / f10;
                this.submodes[this.submodeID].innovation.unquant(this.exc, n4, this.subframeSize, bits);
                n = n4;
                while (n < n4 + this.subframeSize) {
                    int n8 = n++;
                    this.exc[n8] = this.exc[n8] * f11;
                }
                if (this.submodes[this.submodeID].double_codebook != 0) {
                    for (n = 0; n < this.subframeSize; ++n) {
                        this.innov2[n] = 0.0f;
                    }
                    this.submodes[this.submodeID].innovation.unquant(this.innov2, 0, this.subframeSize, bits);
                    n = 0;
                    while (n < this.subframeSize) {
                        int n9 = n++;
                        this.innov2[n9] = this.innov2[n9] * (f11 * 0.4f);
                    }
                    for (n = 0; n < this.subframeSize; ++n) {
                        int n10 = n4 + n;
                        this.exc[n10] = this.exc[n10] + this.innov2[n];
                    }
                }
            }
            for (n = n4; n < n4 + this.subframeSize; ++n) {
                this.high[n] = this.exc[n];
            }
            Filters.filter_mem2(this.high, n4, this.awk2, this.awk1, this.subframeSize, this.lpcSize, this.mem_sp, this.lpcSize);
            Filters.filter_mem2(this.high, n4, this.awk3, this.interp_qlpc, this.subframeSize, this.lpcSize, this.mem_sp, 0);
        }
        this.filters.fir_mem_up(this.x0d, h0, this.y0, this.full_frame_size, 64, this.g0_mem);
        this.filters.fir_mem_up(this.high, h1, this.y1, this.full_frame_size, 64, this.g1_mem);
        for (n = 0; n < this.full_frame_size; ++n) {
            fArray[n] = 2.0f * (this.y0[n] - this.y1[n]);
        }
        for (n = 0; n < this.lpcSize; ++n) {
            this.old_qlsp[n] = this.qlsp[n];
        }
        this.first = 0;
        return 0;
    }

    public int getFrameSize() {
        return this.full_frame_size;
    }

    public float[] getPiGain() {
        return this.pi_gain;
    }

    public float[] getExc() {
        int n;
        float[] fArray = new float[this.full_frame_size];
        for (n = 0; n < this.full_frame_size; ++n) {
            fArray[n] = 0.0f;
        }
        for (n = 0; n < this.frame_size; ++n) {
            fArray[2 * n] = 2.0f * this.exc[n];
        }
        return fArray;
    }

    public float[] getInnov() {
        return this.getExc();
    }
}

