/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import org.xiph.speex.Bits;

public abstract class LspQuant {
    public static final int MAX_LSP_SIZE = 20;
    public static final int NB_CDBK_SIZE = 64;
    public static final int NB_CDBK_SIZE_LOW1 = 64;
    public static final int NB_CDBK_SIZE_LOW2 = 64;
    public static final int NB_CDBK_SIZE_HIGH1 = 64;
    public static final int NB_CDBK_SIZE_HIGH2 = 64;
    protected float[] quant_weight = new float[20];

    protected LspQuant() {
    }

    public abstract void quant(float[] var1, float[] var2, int var3, Bits var4);

    public abstract void unquant(float[] var1, int var2, Bits var3);

    protected void unpackPlus(float[] fArray, int[] nArray, Bits bits, float f, int n, int n2) {
        int n3 = bits.unpack(6);
        for (int i = 0; i < n; ++i) {
            int n4 = i + n2;
            fArray[n4] = fArray[n4] + f * (float)nArray[n3 * n + i];
        }
    }

    protected static int lsp_quant(float[] fArray, int n, int[] nArray, int n2, int n3) {
        int n4;
        float f = 0.0f;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n2; ++i) {
            float f2 = 0.0f;
            for (n4 = 0; n4 < n3; ++n4) {
                float f3 = fArray[n + n4] - (float)nArray[n6++];
                f2 += f3 * f3;
            }
            if (!(f2 < f) && i != 0) continue;
            f = f2;
            n5 = i;
        }
        for (n4 = 0; n4 < n3; ++n4) {
            int n7 = n + n4;
            fArray[n7] = fArray[n7] - (float)nArray[n5 * n3 + n4];
        }
        return n5;
    }

    protected static int lsp_weight_quant(float[] fArray, int n, float[] fArray2, int n2, int[] nArray, int n3, int n4) {
        int n5;
        float f = 0.0f;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n3; ++i) {
            float f2 = 0.0f;
            for (n5 = 0; n5 < n4; ++n5) {
                float f3 = fArray[n + n5] - (float)nArray[n7++];
                f2 += fArray2[n2 + n5] * f3 * f3;
            }
            if (!(f2 < f) && i != 0) continue;
            f = f2;
            n6 = i;
        }
        for (n5 = 0; n5 < n4; ++n5) {
            int n8 = n + n5;
            fArray[n8] = fArray[n8] - (float)nArray[n6 * n4 + n5];
        }
        return n6;
    }
}

