/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PcmWaveWriter {
    private RandomAccessFile raf;
    private int channels;
    private int sampleRate;
    private int size = 0;

    public void close() throws IOException {
        this.raf.seek(4L);
        int n = (int)this.raf.length() - 8;
        this.writeInt(n);
        this.raf.seek(40L);
        this.writeInt(this.size);
        this.raf.close();
    }

    public void open(String string) throws IOException {
        new File(string).delete();
        this.raf = new RandomAccessFile(string, "rw");
        this.size = 0;
    }

    public void setFormat(int n, int n2) {
        this.channels = n;
        this.sampleRate = n2;
    }

    public void writeHeader() throws IOException {
        byte[] byArray = new String("RIFF").getBytes();
        this.raf.write(byArray, 0, byArray.length);
        this.writeInt(0);
        byArray = new String("WAVE").getBytes();
        this.raf.write(byArray, 0, byArray.length);
        byArray = new String("fmt ").getBytes();
        this.raf.write(byArray, 0, byArray.length);
        this.writeInt(16);
        short s = 16;
        this.writeShort((short)1);
        this.writeShort((short)this.channels);
        this.writeInt(this.sampleRate);
        this.writeInt(this.sampleRate * this.channels * (s / 8));
        this.writeShort((short)(this.channels * (s / 8)));
        this.writeShort(s);
        byArray = new String("data").getBytes();
        this.raf.write(byArray, 0, byArray.length);
        this.writeInt(0);
    }

    public void writeData(byte[] byArray, int n, int n2) throws IOException {
        this.raf.write(byArray, n, n2);
        this.size += n2;
    }

    private void writeShort(short s) throws IOException {
        this.raf.writeByte(0xFF & s);
        this.raf.writeByte(0xFF & s >>> 8);
    }

    private void writeInt(int n) throws IOException {
        this.raf.writeByte(0xFF & n);
        this.raf.writeByte(0xFF & n >>> 8);
        this.raf.writeByte(0xFF & n >>> 16);
        this.raf.writeByte(0xFF & n >>> 24);
    }
}

