/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import org.xiph.speex.Bits;
import org.xiph.speex.Decoder;
import org.xiph.speex.ModesNB;
import org.xiph.speex.ModesWB;
import org.xiph.speex.NbDecoder;
import org.xiph.speex.UwbDecoder;
import org.xiph.speex.WbDecoder;

public class SpeexDecoder {
    public static final String VERSION = "Java Speex Decoder v0.6 ($Revision: 1.1 $)";
    private int packetNo = 0;
    private int sampleRate = 0;
    private int channelCount = 0;
    private float[] decodedData;
    private short[] outputData;
    private int outputSize;
    private Bits bits = new Bits();
    private Decoder decoder;
    private int frameSize;
    private boolean headerRead = false;

    public boolean init(int n, int n2, int n3) {
        if (n == 0) {
            new ModesNB().init();
        } else {
            new ModesWB().init();
        }
        switch (n) {
            case 0: {
                this.decoder = new NbDecoder();
                break;
            }
            case 1: {
                this.decoder = new WbDecoder();
                break;
            }
            case 2: {
                this.decoder = new UwbDecoder();
                break;
            }
            default: {
                return false;
            }
        }
        this.decoder.init();
        this.frameSize = this.decoder.getFrameSize();
        this.sampleRate = n2;
        this.channelCount = n3;
        int n4 = this.sampleRate * this.channelCount;
        this.decodedData = new float[n4 * 2];
        this.outputData = new short[n4 * 2];
        this.packetNo = 0;
        this.outputSize = 0;
        this.headerRead = true;
        this.bits.init();
        return true;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channelCount;
    }

    public int getProcessedData(byte[] byArray, int n) {
        int n2;
        if (this.outputSize <= 0) {
            return this.outputSize;
        }
        for (n2 = 0; n2 < this.outputSize; ++n2) {
            int n3 = n + (n2 << 1);
            byArray[n3] = (byte)(this.outputData[n2] & 0xFF);
            byArray[n3 + 1] = (byte)(this.outputData[n2] >> 8 & 0xFF);
        }
        n2 = this.outputSize * 2;
        this.outputSize = 0;
        return n2;
    }

    public int getProcessedData(short[] sArray, int n) {
        int n2;
        if (this.outputSize <= 0) {
            return this.outputSize;
        }
        for (n2 = 0; n2 < this.outputSize; ++n2) {
            sArray[n + n2] = this.outputData[n2];
        }
        n2 = this.outputSize;
        this.outputSize = 0;
        return n2;
    }

    public int getProcessedDataByteSize() {
        return this.outputSize * 2;
    }

    public boolean processData(byte[] byArray, int n, int n2) {
        int n3 = 0;
        if (this.packetNo > 0 && !this.headerRead) {
            return false;
        }
        if (!this.headerRead) {
            if (!this.readHeader(byArray, n, n2)) {
                ++this.packetNo;
                return false;
            }
        } else if (this.packetNo != 1) {
            this.bits.read_from(byArray, n, n2);
            this.decoder.decode(this.bits, this.decodedData);
            if (this.channelCount == 2) {
                this.decoder.decodeStereo(this.decodedData, this.frameSize);
            }
            for (n3 = 0; n3 < this.frameSize * this.channelCount; ++n3) {
                if (this.decodedData[n3] > 32767.0f) {
                    this.decodedData[n3] = 32767.0f;
                    continue;
                }
                if (!(this.decodedData[n3] < -32768.0f)) continue;
                this.decodedData[n3] = -32768.0f;
            }
            n3 = 0;
            while (n3 < this.frameSize * this.channelCount) {
                this.outputData[this.outputSize] = this.decodedData[n3] > 0.0f ? (short)((double)this.decodedData[n3] + 0.5) : (short)((double)this.decodedData[n3] - 0.5);
                ++n3;
                ++this.outputSize;
            }
        }
        ++this.packetNo;
        return true;
    }

    private boolean readHeader(byte[] byArray, int n, int n2) {
        if (n2 != 80) {
            return false;
        }
        if (!"Speex   ".equals(new String(byArray, 0, 8))) {
            return false;
        }
        int n3 = byArray[40 + n] & 0xFF;
        this.sampleRate = this.bytestoint(byArray, n + 36);
        this.channelCount = this.bytestoint(byArray, n + 48);
        return this.init(n3, this.sampleRate, this.channelCount);
    }

    private int bytestoint(byte[] byArray, int n) {
        return (byArray[n + 3] & 0xFF) << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n + 0] & 0xFF;
    }
}

