/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Random;
import org.xiph.speex.OggCrc;

public class OggSpeexWriter {
    private Random random = new Random();
    private RandomAccessFile raf;
    private OutputStream outStream;
    private int mode;
    private int sampleRate;
    private int channels;
    private int streamSerialNumber = this.random.nextInt();
    private byte[] dataBuffer = new byte[65565];
    private int dataBufferPtr = 0;
    private byte[] headerBuffer = new byte[255];
    private int headerBufferPtr = 0;
    private int pageCount = 0;
    private int packetCount = 0;
    private long granulepos = 0L;

    public OggSpeexWriter() {
    }

    public OggSpeexWriter(OutputStream outputStream) {
        this();
        this.outStream = outputStream;
    }

    public void close() throws IOException {
        this.flush(true);
        if (this.raf != null) {
            this.raf.close();
        }
    }

    public void open(String string) throws IOException {
        if (this.outStream != null) {
            throw new IOException("OutputStream already open for this writer.");
        }
        new File(string).delete();
        this.raf = new RandomAccessFile(string, "rw");
    }

    private void write(byte[] byArray) throws IOException {
        if (this.raf != null) {
            this.raf.write(byArray);
        } else {
            this.outStream.write(byArray);
        }
    }

    private void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.raf != null) {
            this.raf.write(byArray, n, n2);
        } else {
            this.outStream.write(byArray, n, n2);
        }
    }

    public void setFormat(int n, int n2, int n3) {
        this.mode = n;
        this.sampleRate = n2;
        this.channels = n3;
    }

    public void writeHeader() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(108);
        byteArrayOutputStream.write("OggS".getBytes(), 0, 4);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(2);
        OggSpeexWriter.writeLong(byteArrayOutputStream, 0L);
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.streamSerialNumber);
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.pageCount++);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 0);
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(80);
        byteArrayOutputStream.write("Speex   ".getBytes(), 0, 8);
        byteArrayOutputStream.write("speex-1.0".getBytes(), 0, 9);
        byteArrayOutputStream.write(new byte[11], 0, 11);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 1);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 80);
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.sampleRate);
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.mode);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 4);
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.channels);
        OggSpeexWriter.writeInt(byteArrayOutputStream, -1);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 160);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 0);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 1);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 0);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 0);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 0);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        int n = OggCrc.checksum(0, byArray, 0, byArray.length);
        byArray[22] = (byte)(0xFF & n);
        byArray[23] = (byte)(0xFF & n >>> 8);
        byArray[24] = (byte)(0xFF & n >>> 16);
        byArray[25] = (byte)(0xFF & n >>> 24);
        this.write(byArray);
        byteArrayOutputStream = new ByteArrayOutputStream(64);
        String string = "Encoded with jspeex 0.6";
        byteArrayOutputStream.write("OggS".getBytes(), 0, 4);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        OggSpeexWriter.writeLong(byteArrayOutputStream, 0L);
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.streamSerialNumber);
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.pageCount++);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 0);
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(0xFF & string.length() + 8);
        OggSpeexWriter.writeInt(byteArrayOutputStream, string.length());
        byteArrayOutputStream.write(string.getBytes(), 0, string.length());
        OggSpeexWriter.writeInt(byteArrayOutputStream, 0);
        byArray = byteArrayOutputStream.toByteArray();
        n = OggCrc.checksum(0, byArray, 0, byArray.length);
        byArray[22] = (byte)(0xFF & n);
        byArray[23] = (byte)(0xFF & n >>> 8);
        byArray[24] = (byte)(0xFF & n >>> 16);
        byArray[25] = (byte)(0xFF & n >>> 24);
        this.write(byArray);
    }

    public void writePacket(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        if (this.packetCount > 250) {
            this.flush(false);
        }
        System.arraycopy(byArray, n, this.dataBuffer, this.dataBufferPtr, n2);
        this.dataBufferPtr += n2;
        this.headerBuffer[this.headerBufferPtr++] = (byte)n2;
        ++this.packetCount;
        this.granulepos += (long)(this.mode == 0 ? 160 : 320);
    }

    public void flush(boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(284);
        byteArrayOutputStream.write("OggS".getBytes(), 0, 4);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0xFF & (bl ? 4 : 0));
        OggSpeexWriter.writeLong(byteArrayOutputStream, this.granulepos);
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.streamSerialNumber);
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.pageCount++);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 0);
        byteArrayOutputStream.write(0xFF & this.packetCount);
        byteArrayOutputStream.write(this.headerBuffer, 0, this.packetCount);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        int n = OggCrc.checksum(0, byArray, 0, byArray.length);
        n = OggCrc.checksum(n, this.dataBuffer, 0, this.dataBufferPtr);
        byArray[22] = (byte)(0xFF & n);
        byArray[23] = (byte)(0xFF & n >>> 8);
        byArray[24] = (byte)(0xFF & n >>> 16);
        byArray[25] = (byte)(0xFF & n >>> 24);
        this.write(byArray);
        this.write(this.dataBuffer, 0, this.dataBufferPtr);
        this.dataBufferPtr = 0;
        this.headerBufferPtr = 0;
        this.packetCount = 0;
    }

    private static void writeShort(OutputStream outputStream, short s) throws IOException {
        outputStream.write(0xFF & s);
        outputStream.write(0xFF & s >>> 8);
    }

    private static void writeInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write(0xFF & n);
        outputStream.write(0xFF & n >>> 8);
        outputStream.write(0xFF & n >>> 16);
        outputStream.write(0xFF & n >>> 24);
    }

    private static void writeLong(OutputStream outputStream, long l) throws IOException {
        outputStream.write((int)(0xFFL & l));
        outputStream.write((int)(0xFFL & l >>> 8));
        outputStream.write((int)(0xFFL & l >>> 16));
        outputStream.write((int)(0xFFL & l >>> 24));
        outputStream.write((int)(0xFFL & l >>> 32));
        outputStream.write((int)(0xFFL & l >>> 40));
        outputStream.write((int)(0xFFL & l >>> 48));
        outputStream.write((int)(0xFFL & l >>> 56));
    }
}

