/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import org.xiph.speex.Bits;
import org.xiph.speex.Decoder;
import org.xiph.speex.Filters;
import org.xiph.speex.Lsp;
import org.xiph.speex.ModesNB;
import org.xiph.speex.SubMode;

public class NbDecoder
extends Decoder {
    public static float[] exc_gain_quant_scal3 = new float[]{-2.79475f, -1.81066f, -1.16985f, -0.848119f, -0.58719f, -0.329818f, -0.063266f, 0.282826f};
    public static float[] exc_gain_quant_scal1 = new float[]{-0.35f, 0.05f};
    private int first;
    private int frameSize;
    private int subframeSize;
    private int nbSubframes;
    private int windowSize;
    private int lpcSize;
    private int bufSize;
    private int min_pitch;
    private int max_pitch;
    private float[] frmBuf;
    private int frmIdx;
    private float[] excBuf;
    private int excIdx;
    private float[] innov;
    private float[] qlsp;
    private float[] old_qlsp;
    private float[] interp_qlsp;
    private float[] interp_qlpc;
    private float[] mem_sp;
    private float[] pi_gain;
    private float[] awk1;
    private float[] awk2;
    private float[] awk3;
    private float[] lpc;
    private float[] innov2;
    private SubMode[] submodes;
    private int submodeID;
    private float voc_m1;
    private float voc_m2;
    private float voc_mean;
    private int voc_offset;

    public void init() {
        this.first = 1;
        this.frameSize = 160;
        this.windowSize = this.frameSize * 3 / 2;
        this.subframeSize = 40;
        this.nbSubframes = this.frameSize / this.subframeSize;
        this.lpcSize = 10;
        this.bufSize = 640;
        this.min_pitch = 17;
        this.max_pitch = 144;
        this.submodes = ModesNB.nbsubmodes;
        this.submodeID = 5;
        this.frmBuf = new float[this.bufSize];
        this.frmIdx = this.bufSize - this.windowSize;
        this.excBuf = new float[this.bufSize];
        this.excIdx = this.bufSize - this.windowSize;
        this.innov = new float[this.frameSize];
        this.interp_qlpc = new float[this.lpcSize + 1];
        this.qlsp = new float[this.lpcSize];
        this.old_qlsp = new float[this.lpcSize];
        this.interp_qlsp = new float[this.lpcSize];
        this.mem_sp = new float[5 * this.lpcSize];
        this.awk1 = new float[11];
        this.awk2 = new float[11];
        this.awk3 = new float[11];
        this.innov2 = new float[40];
        this.lpc = new float[40];
        this.filters.init();
        this.pi_gain = new float[this.nbSubframes];
        this.voc_mean = 0.0f;
        this.voc_m2 = 0.0f;
        this.voc_m1 = 0.0f;
        this.voc_offset = 0;
    }

    public int decode(Bits bits, float[] fArray) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        float[] fArray2 = new float[3];
        float f = 0.0f;
        float f2 = 0.0f;
        do {
            if (bits.unpack(1) != 0) {
                return 1;
            }
            n3 = bits.unpack(4);
            if (n3 == 15) {
                return 1;
            }
            if (n3 == 14) {
                n2 = this.speexInbandRequest(bits);
                if (n2 == 0) continue;
                return n2;
            }
            if (n3 == 13) {
                n2 = this.userInbandRequest(bits);
                if (n2 == 0) continue;
                return n2;
            }
            if (n3 <= 8) continue;
            System.err.println("Invalid mode encountered: corrupted stream?");
            return 2;
        } while (n3 > 8);
        this.submodeID = n3;
        System.arraycopy(this.frmBuf, this.frameSize, this.frmBuf, 0, this.bufSize - this.frameSize);
        System.arraycopy(this.excBuf, this.frameSize, this.excBuf, 0, this.bufSize - this.frameSize);
        if (this.submodes[this.submodeID] == null) {
            int n5;
            Filters.bw_lpc(0.93f, this.interp_qlpc, this.lpc, 10);
            float f3 = 0.0f;
            for (n5 = 0; n5 < this.frameSize; ++n5) {
                f3 += this.innov[n5] * this.innov[n5];
            }
            f3 = (float)Math.sqrt(f3 / (float)this.frameSize);
            for (n5 = this.excIdx; n5 < this.excIdx + this.frameSize; ++n5) {
                this.excBuf[n5] = 3.0f * f3 * ((float)Math.random() - 0.5f);
            }
            this.first = 1;
            Filters.iir_mem2(this.excBuf, this.excIdx, this.lpc, this.frmBuf, this.frmIdx, this.frameSize, this.lpcSize, this.mem_sp);
            fArray[0] = this.frmBuf[this.frmIdx];
            for (n5 = 1; n5 < this.frameSize; ++n5) {
                fArray[n5] = this.frmBuf[this.frmIdx + n5];
            }
            return 0;
        }
        this.submodes[this.submodeID].lsqQuant.unquant(this.qlsp, this.lpcSize, bits);
        if (this.first != 0) {
            for (n = 0; n < this.lpcSize; ++n) {
                this.old_qlsp[n] = this.qlsp[n];
            }
        }
        if (this.submodes[this.submodeID].lbr_pitch != -1) {
            n4 = this.min_pitch + bits.unpack(7);
        }
        if (this.submodes[this.submodeID].forced_pitch_gain != 0) {
            n2 = bits.unpack(4);
            f2 = 0.066667f * (float)n2;
        }
        n2 = bits.unpack(5);
        f = (float)Math.exp((double)n2 / 3.5);
        if (this.submodeID == 1) {
            bits.unpack(4);
        }
        for (int i = 0; i < this.nbSubframes; ++i) {
            float f4;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10 = this.frmIdx + this.subframeSize * i;
            int n11 = this.excIdx + this.subframeSize * i;
            float f5 = (1.0f + (float)i) / (float)this.nbSubframes;
            for (n = 0; n < this.lpcSize; ++n) {
                this.interp_qlsp[n] = (1.0f - f5) * this.old_qlsp[n] + f5 * this.qlsp[n];
            }
            Lsp.enforce_margin(this.interp_qlsp, this.lpcSize, 0.002f);
            for (n = 0; n < this.lpcSize; ++n) {
                this.interp_qlsp[n] = (float)Math.cos(this.interp_qlsp[n]);
            }
            this.m_lsp.lsp2lpc(this.interp_qlsp, this.interp_qlpc, this.lpcSize);
            float f6 = 0.9f;
            float f7 = this.submodes[this.submodeID].lpc_enh_k1;
            float f8 = this.submodes[this.submodeID].lpc_enh_k2;
            float f9 = (1.0f - (1.0f - f6 * f7) / (1.0f - f6 * f8)) / f6;
            Filters.bw_lpc(f7, this.interp_qlpc, this.awk1, this.lpcSize);
            Filters.bw_lpc(f8, this.interp_qlpc, this.awk2, this.lpcSize);
            Filters.bw_lpc(f9, this.interp_qlpc, this.awk3, this.lpcSize);
            f5 = 1.0f;
            this.pi_gain[i] = 0.0f;
            for (n = 0; n <= this.lpcSize; ++n) {
                int n12 = i;
                this.pi_gain[n12] = this.pi_gain[n12] + f5 * this.interp_qlpc[n];
                f5 = -f5;
            }
            for (n = 0; n < this.subframeSize; ++n) {
                this.excBuf[n11 + n] = 0.0f;
            }
            if (this.submodes[this.submodeID].lbr_pitch != -1) {
                n9 = this.submodes[this.submodeID].lbr_pitch;
                if (n9 != 0) {
                    n8 = n4 - n9 + 1;
                    if (n8 < this.min_pitch) {
                        n8 = this.min_pitch;
                    }
                    if ((n7 = n4 + n9) > this.max_pitch) {
                        n7 = this.max_pitch;
                    }
                } else {
                    n8 = n7 = n4;
                }
            } else {
                n8 = this.min_pitch;
                n7 = this.max_pitch;
            }
            int n13 = this.submodes[this.submodeID].ltp.unquant(this.excBuf, n11, n8, f2, this.subframeSize, fArray2, bits);
            for (n = n6 = i * this.subframeSize; n < n6 + this.subframeSize; ++n) {
                this.innov[n] = 0.0f;
            }
            if (this.submodes[this.submodeID].have_subframe_gain == 3) {
                n9 = bits.unpack(3);
                f4 = (float)((double)f * Math.exp(exc_gain_quant_scal3[n9]));
            } else if (this.submodes[this.submodeID].have_subframe_gain == 1) {
                n9 = bits.unpack(1);
                f4 = (float)((double)f * Math.exp(exc_gain_quant_scal1[n9]));
            } else {
                f4 = f;
            }
            if (this.submodes[this.submodeID].innovation != null) {
                this.submodes[this.submodeID].innovation.unquant(this.innov, n6, this.subframeSize, bits);
            }
            n = n6;
            while (n < n6 + this.subframeSize) {
                int n14 = n++;
                this.innov[n14] = this.innov[n14] * f4;
            }
            if (this.submodeID == 1) {
                float f10 = f2;
                for (n = 0; n < this.subframeSize; ++n) {
                    this.excBuf[n11 + n] = 0.0f;
                }
                while (this.voc_offset < this.subframeSize) {
                    if (this.voc_offset >= 0) {
                        this.excBuf[n11 + this.voc_offset] = (float)Math.sqrt(1.0f * (float)n4);
                    }
                    this.voc_offset += n4;
                }
                this.voc_offset -= this.subframeSize;
                if ((f10 = 0.5f + 2.0f * (f10 - 0.6f)) < 0.0f) {
                    f10 = 0.0f;
                }
                if (f10 > 1.0f) {
                    f10 = 1.0f;
                }
                for (n = 0; n < this.subframeSize; ++n) {
                    float f11 = this.excBuf[n11 + n];
                    this.excBuf[n11 + n] = 0.8f * f10 * this.excBuf[n11 + n] * f + 0.6f * f10 * this.voc_m1 * f + 0.5f * f10 * this.innov[n6 + n] - 0.5f * f10 * this.voc_m2 + (1.0f - f10) * this.innov[n6 + n];
                    this.voc_m1 = f11;
                    this.voc_m2 = this.innov[n6 + n];
                    this.voc_mean = 0.95f * this.voc_mean + 0.05f * this.excBuf[n11 + n];
                    int n15 = n11 + n;
                    this.excBuf[n15] = this.excBuf[n15] - this.voc_mean;
                }
            } else {
                for (n = 0; n < this.subframeSize; ++n) {
                    int n16 = n11 + n;
                    this.excBuf[n16] = this.excBuf[n16] + this.innov[n6 + n];
                }
            }
            if (this.submodes[this.submodeID].double_codebook != 0) {
                for (n = 0; n < this.subframeSize; ++n) {
                    this.innov2[n] = 0.0f;
                }
                this.submodes[this.submodeID].innovation.unquant(this.innov2, 0, this.subframeSize, bits);
                n = 0;
                while (n < this.subframeSize) {
                    int n17 = n++;
                    this.innov2[n17] = (float)((double)this.innov2[n17] * ((double)f4 * 0.45454545454545453));
                }
                for (n = 0; n < this.subframeSize; ++n) {
                    int n18 = n11 + n;
                    this.excBuf[n18] = this.excBuf[n18] + this.innov2[n];
                }
            }
            for (n = 0; n < this.subframeSize; ++n) {
                this.frmBuf[n10 + n] = this.excBuf[n11 + n];
            }
            if (this.submodes[this.submodeID].comb_gain > 0.0f) {
                this.filters.comb_filter(this.excBuf, n11, this.frmBuf, n10, this.subframeSize, n13, fArray2, this.submodes[this.submodeID].comb_gain);
            }
            Filters.filter_mem2(this.frmBuf, n10, this.awk2, this.awk1, this.subframeSize, this.lpcSize, this.mem_sp, this.lpcSize);
            Filters.filter_mem2(this.frmBuf, n10, this.awk3, this.interp_qlpc, this.subframeSize, this.lpcSize, this.mem_sp, 0);
        }
        fArray[0] = this.frmBuf[this.frmIdx];
        for (n = 1; n < this.frameSize; ++n) {
            fArray[n] = this.frmBuf[this.frmIdx + n];
        }
        for (n = 0; n < this.lpcSize; ++n) {
            this.old_qlsp[n] = this.qlsp[n];
        }
        this.first = 0;
        return 0;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public float[] getPiGain() {
        return this.pi_gain;
    }

    public float[] getExc() {
        float[] fArray = new float[this.frameSize];
        System.arraycopy(this.excBuf, this.excIdx, fArray, 0, this.frameSize);
        return fArray;
    }

    public float[] getInnov() {
        return this.innov;
    }
}

