/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import org.xiph.speex.Bits;
import org.xiph.speex.Filters;
import org.xiph.speex.Lsp;
import org.xiph.speex.Stereo;

public abstract class Decoder {
    protected Lsp m_lsp = new Lsp();
    protected Filters filters = new Filters();
    protected Stereo stereo = new Stereo();

    public abstract void init();

    public abstract int decode(Bits var1, float[] var2);

    public void decodeStereo(float[] fArray, int n) {
        this.stereo.decode(fArray, n);
    }

    public abstract int getFrameSize();

    public abstract float[] getPiGain();

    public abstract float[] getExc();

    public abstract float[] getInnov();

    protected int speexInbandRequest(Bits bits) {
        int n = bits.unpack(4);
        switch (n) {
            case 0: {
                int n2 = bits.unpack(1);
                break;
            }
            case 1: {
                int n3 = bits.unpack(1);
                break;
            }
            case 2: {
                int n4 = bits.unpack(4);
                break;
            }
            case 3: {
                int n5 = bits.unpack(4);
                break;
            }
            case 4: {
                int n6 = bits.unpack(4);
                break;
            }
            case 5: {
                int n7 = bits.unpack(4);
                break;
            }
            case 6: {
                int n8 = bits.unpack(4);
                break;
            }
            case 7: {
                int n9 = bits.unpack(4);
                break;
            }
            case 8: {
                int n10 = bits.unpack(8);
                break;
            }
            case 9: {
                return this.stereo.init(bits);
            }
            case 10: {
                int n11 = bits.unpack(16);
                break;
            }
            case 11: {
                int n12 = bits.unpack(16);
                break;
            }
            case 12: {
                int n13 = bits.unpack(32);
                break;
            }
            case 13: {
                int n14 = bits.unpack(32);
                break;
            }
            case 14: {
                int n15 = bits.unpack(64);
                break;
            }
            case 15: {
                int n16 = bits.unpack(64);
                break;
            }
        }
        return 1;
    }

    protected int userInbandRequest(Bits bits) {
        return 1;
    }
}

