/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import org.xiph.speex.Bits;
import org.xiph.speex.Filters;
import org.xiph.speex.Lsp;
import org.xiph.speex.SubMode;

public abstract class Encoder {
    protected Lsp m_lsp = new Lsp();
    protected Filters filters = new Filters();
    protected int complexity;
    protected int vbr_enabled;
    protected int vad_enabled;
    protected int dtx_enabled;
    protected int abr_enabled;
    protected float vbr_quality;
    protected float relative_quality;
    protected float abr_drift;
    protected float abr_drift2;
    protected float abr_count;
    protected int sampling_rate;
    protected SubMode[] submodes;
    protected int submodeID;
    protected int submodeSelect;

    public void init() {
        this.complexity = 3;
        this.vbr_enabled = 0;
        this.vad_enabled = 0;
        this.dtx_enabled = 0;
        this.abr_enabled = 0;
        this.vbr_quality = 8.0f;
    }

    public abstract int encode(Bits var1, float[] var2);

    protected float[] window(int n, int n2) {
        int n3;
        int n4 = n2 * 7 / 2;
        int n5 = n2 * 5 / 2;
        float[] fArray = new float[n];
        for (n3 = 0; n3 < n4; ++n3) {
            fArray[n3] = (float)(0.54 - 0.46 * Math.cos(Math.PI * (double)n3 / (double)n4));
        }
        for (n3 = 0; n3 < n5; ++n3) {
            fArray[n4 + n3] = (float)(0.54 + 0.46 * Math.cos(Math.PI * (double)n3 / (double)n5));
        }
        return fArray;
    }

    public abstract int getFrameSize();

    public abstract void setQuality(int var1);

    public abstract int getBitRate();

    public abstract float[] getPiGain();

    public abstract float[] getExc();

    public abstract float[] getInnov();

    public void setMode(int n) {
        this.submodeID = this.submodeSelect = n;
    }

    public int getMode() {
        return this.submodeID;
    }

    public void setBitRate(int n) {
        for (int i = 10; i >= 0; --i) {
            this.setQuality(i);
            if (this.getBitRate() > n) continue;
            return;
        }
    }

    public void setVbr(boolean bl) {
        this.vbr_enabled = bl ? 1 : 0;
    }

    public boolean getVbr() {
        return this.vbr_enabled != 0;
    }

    public void setVad(boolean bl) {
        this.vad_enabled = bl ? 1 : 0;
    }

    public boolean getVad() {
        return this.vad_enabled != 0;
    }

    public void setDtx(boolean bl) {
        this.dtx_enabled = bl ? 1 : 0;
    }

    public boolean getDtx() {
        return this.dtx_enabled != 0;
    }

    public int getAbr() {
        return this.abr_enabled;
    }

    public void setAbr(int n) {
        float f;
        int n2;
        this.abr_enabled = n != 0 ? 1 : 0;
        this.vbr_enabled = 1;
        int n3 = n;
        for (n2 = 10; n2 >= 0; --n2) {
            this.setQuality(n2);
            int n4 = this.getBitRate();
            if (n4 <= n3) break;
        }
        if ((f = (float)n2) < 0.0f) {
            f = 0.0f;
        }
        this.setVbrQuality(f);
        this.abr_count = 0.0f;
        this.abr_drift = 0.0f;
        this.abr_drift2 = 0.0f;
    }

    public void setVbrQuality(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 10.0f) {
            f = 10.0f;
        }
        this.vbr_quality = f;
    }

    public float getVbrQuality() {
        return this.vbr_quality;
    }

    public void setComplexity(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 10) {
            n = 10;
        }
        this.complexity = n;
    }

    public int getComplexity() {
        return this.complexity;
    }

    public void setSamplingRate(int n) {
        this.sampling_rate = n;
    }

    public int getSamplingRate() {
        return this.sampling_rate;
    }

    public float getRelativeQuality() {
        return this.relative_quality;
    }
}

