/*
 * Decompiled with CFR 0.152.
 */
package VarietyGames.CrosswordWeaverLive;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

abstract class Puzzle {
    String m_puzzleTitle = "";
    String m_puzzleAuthor = "";
    String m_puzzleDate = "";
    String m_puzzleCopyright = "";
    boolean m_puzzleUseClock = false;
    int m_puzzleLayout = 0;
    double m_puzzleTextSize = 1.0;
    Color m_puzzleBackgroundColor = Color.white;
    Color m_puzzleTextColor = Color.black;
    Color m_puzzleClueTextColor = Color.black;
    Color m_puzzleClueColor = Color.white;
    Color m_puzzleButtonTextColor = Color.black;
    Color m_puzzleButtonColor = Color.white;
    Color m_clueNumberColor = Color.blue;
    String m_puzzleBackgroundImage = "";
    PuzzlePanel m_puzzlePanel;
    Image m_image;
    PuzzleClock m_puzzleClock;
    String m_path;

    public Puzzle(String string) {
        this.m_path = string;
    }

    void init() {
    }

    public abstract Panel createUI();

    public void parseAttribute(String string, String string2) {
        if (string.equals("PuzzleAuthor") || string.equals("Author")) {
            this.m_puzzleAuthor = string2;
        } else if (string.equals("PuzzleTitle") || string.equals("Title")) {
            this.m_puzzleTitle = string2;
        } else if (string.equals("PuzzleDate") || string.equals("Date")) {
            this.m_puzzleDate = string2;
        } else if (string.equals("PuzzleCopyright") || string.equals("Copyright")) {
            this.m_puzzleCopyright = string2;
        } else if (string.equals("PuzzleUseTimer") || string.equals("UseTimer")) {
            if (string2.equalsIgnoreCase("True")) {
                this.m_puzzleUseClock = true;
            }
        } else if (string.equals("PuzzleBackgroundImage") || string.equals("BackgroundImage")) {
            this.m_puzzleBackgroundImage = string2;
            try {
                URL uRL = new URL(String.valueOf(String.valueOf(this.m_path)).concat(String.valueOf(String.valueOf(this.m_puzzleBackgroundImage))));
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                this.m_image = toolkit.getImage(uRL);
            }
            catch (MalformedURLException malformedURLException) {}
        } else if (string.equals("PuzzleBackgroundColor")) {
            try {
                this.m_puzzleBackgroundColor = Color.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.m_puzzleBackgroundColor = Color.white;
            }
        } else if (string.equals("PuzzleTextColor")) {
            try {
                this.m_puzzleTextColor = Color.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.m_puzzleTextColor = Color.black;
            }
        } else if (string.equals("PuzzleClueBackgroundColor")) {
            try {
                this.m_puzzleClueColor = Color.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.m_puzzleClueColor = Color.white;
            }
        } else if (string.equals("PuzzleClueTextColor")) {
            try {
                this.m_puzzleClueTextColor = Color.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.m_puzzleClueTextColor = Color.black;
            }
        } else if (string.equals("PuzzleButtonBackgroundColor")) {
            try {
                this.m_puzzleButtonColor = Color.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.m_puzzleButtonColor = Color.white;
            }
        } else if (string.equals("PuzzleButtonTextColor")) {
            try {
                this.m_puzzleButtonTextColor = Color.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.m_puzzleButtonTextColor = Color.black;
            }
        } else if (string.equals("PuzzleClueNumberColor")) {
            try {
                this.m_clueNumberColor = Color.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.m_clueNumberColor = Color.blue;
            }
        } else if (string.equals("PuzzleLayout")) {
            if (string2.equals("Left")) {
                this.m_puzzleLayout = 0;
            } else if (string2.equals("Center")) {
                this.m_puzzleLayout = 1;
            } else if (string2.equals("Right")) {
                this.m_puzzleLayout = 2;
            } else if (string2.equals("NoClues")) {
                this.m_puzzleLayout = 3;
            }
        } else if (string.equals("PuzzleTextSize") || string.equals("TextSize")) {
            if (string2.equals("Small")) {
                this.m_puzzleTextSize = 0.9;
            } else if (string2.equals("Smaller")) {
                this.m_puzzleTextSize = 0.75;
            } else if (string2.equals("Smallest")) {
                this.m_puzzleTextSize = 0.5;
            } else if (string2.equals("Large")) {
                this.m_puzzleTextSize = 1.175;
            } else if (string2.equals("Larger")) {
                this.m_puzzleTextSize = 1.5;
            } else if (string2.equals("Largest")) {
                this.m_puzzleTextSize = 2.25;
            }
        }
    }

    boolean registered() {
        return false;
    }

    void animate(int n, int n2) {
    }

    void keyPress(char c) {
    }

    void keyPressSpecial(int n) {
    }

    void mousePress(int n, int n2, int n3) {
    }

    void mouseRelease(int n, int n2, int n3) {
    }

    void listItemSelected(int n, int n2) {
    }

    void buttonPushed(int n) {
    }

    void requestFocus() {
        this.m_puzzlePanel.requestFocus();
    }

    void repaint() {
        this.m_puzzlePanel.repaint();
    }

    class WrappedList
    extends List {
        Vector map = new Vector();
        Vector original = new Vector();
        int items = 0;
        Dimension d;

        WrappedList() {
            this.setMultipleMode(false);
        }

        public void add(String string) {
            int n = (int)((double)170 * Puzzle.this.m_puzzleTextSize);
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.original.addElement(string);
            while (string.length() > 0) {
                if (fontMetrics.stringWidth(string) > n) {
                    int n2 = 0;
                    for (n2 = string.length(); n2 >= 5 && (fontMetrics.stringWidth(string.substring(0, n2)) >= n || string.charAt(n2) != ' '); --n2) {
                    }
                    if (n2 < 5) {
                        for (n2 = 5; n2 < string.length() && fontMetrics.stringWidth(String.valueOf(String.valueOf(string.substring(0, n2))).concat("-")) < n && string.charAt(n2) != ' '; ++n2) {
                        }
                    }
                    if (string.charAt(n2) == ' ') {
                        super.add(string.substring(0, n2));
                        string = n2 + 1 < string.length() ? String.valueOf(String.valueOf(new String("     "))).concat(String.valueOf(String.valueOf(string.substring(n2 + 1, string.length())))) : "";
                    } else {
                        super.add(String.valueOf(String.valueOf(string.substring(0, n2))).concat("-"));
                        string = n2 < string.length() ? String.valueOf(String.valueOf(new String("     "))).concat(String.valueOf(String.valueOf(string.substring(n2, string.length())))) : "";
                    }
                    this.map.addElement(new Integer(this.items));
                    continue;
                }
                super.add(string);
                string = "";
                this.map.addElement(new Integer(this.items));
            }
            ++this.items;
        }

        public void removeAll() {
            this.map.removeAllElements();
            this.original.removeAllElements();
            super.removeAll();
            this.items = 0;
        }

        public void remove(String string) {
            if (this.original.contains(string)) {
                int n = this.original.indexOf(string);
                if (this.map.contains(new Integer(n))) {
                    for (int i = this.map.lastIndexOf(new Integer(n)); i >= this.map.indexOf(new Integer(n)); --i) {
                        if (!this.map.elementAt(i).equals(new Integer(n))) continue;
                        super.remove(i);
                    }
                }
                while (this.map.contains(new Integer(n))) {
                    this.map.removeElement(new Integer(n));
                    --this.items;
                }
            }
        }

        public int getSelectedIndex() {
            int[] nArray = super.getSelectedIndexes();
            if (nArray.length > 0) {
                return (Integer)this.map.elementAt(nArray[0]);
            }
            return -1;
        }

        public void select(int n) {
            int n2;
            int[] nArray = super.getSelectedIndexes();
            if (this.map.indexOf(new Integer(n)) >= 0 && this.map.elementAt(n2 = this.map.indexOf(new Integer(n))).equals(new Integer(n))) {
                super.select(n2);
            }
        }

        public void makeVisible(int n) {
            super.makeVisible(this.map.lastIndexOf(new Integer(n)));
            super.makeVisible(this.map.indexOf(new Integer(n)));
        }

        public void deselect(int n) {
            if (this.map.indexOf(new Integer(n)) >= 0) {
                for (int i = this.map.indexOf(new Integer(n)); i <= this.map.lastIndexOf(new Integer(n)); ++i) {
                    if (!this.map.elementAt(i).equals(new Integer(n))) continue;
                    super.deselect(i);
                }
            }
        }
    }

    class BetterFlowLayout
    extends FlowLayout {
        BetterFlowLayout(Puzzle puzzle) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension(this.getHgap(), this.getVgap());
            Dimension dimension2 = container.getSize();
            int n = container.getComponentCount();
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                Dimension dimension3 = container.getComponent(i).getPreferredSize();
                n3 = n3 + dimension3.width + this.getHgap();
                if (n2 < dimension3.height) {
                    n2 = dimension3.height;
                }
                if (dimension2.width <= 0 || !((double)n3 >= (double)dimension2.width / 1.1)) continue;
                if (dimension.width < n3) {
                    dimension.width = n3;
                }
                dimension.height = dimension.height + n2 + this.getVgap();
                n2 = 0;
                n3 = 0;
            }
            if (n3 > 0) {
                if (dimension.width < n3) {
                    dimension.width = n3;
                }
                dimension.height = dimension.height + n2 + this.getVgap();
                n2 = 0;
                n3 = 0;
            }
            return dimension;
        }
    }

    public class PuzzleAnimator
    implements Runnable {
        Thread animator;
        int frame;
        int delay;
        int m_animation;

        PuzzleAnimator(int n, int n2) {
            this.m_animation = n;
            this.delay = n2 > 0 ? 1000 / n2 : 100;
        }

        public void init() {
        }

        public void start() {
            this.animator = new Thread(this);
            this.animator.start();
        }

        public void run() {
            long l = System.currentTimeMillis();
            while (Thread.currentThread() == this.animator) {
                Puzzle.this.animate(this.m_animation, this.frame);
                try {
                    Thread.sleep(Math.max(0L, (l += (long)this.delay) - System.currentTimeMillis()));
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                ++this.frame;
            }
        }

        public void stop() {
            this.animator = null;
        }
    }

    class PuzzleClock
    extends Panel
    implements Runnable {
        private Thread m_puzzleClockThread = null;
        Label m_clock;
        boolean m_done = false;
        boolean m_running = false;
        long startTime = System.currentTimeMillis();
        long currentTime = System.currentTimeMillis();

        PuzzleClock(Puzzle puzzle) {
            this.m_clock = new Label();
            this.m_clock.setAlignment(1);
            this.m_clock.setBackground(puzzle.m_puzzleBackgroundColor);
            this.m_clock.setForeground(puzzle.m_puzzleTextColor);
            this.m_clock.setText("0:00");
            this.m_clock.setFont(new Font("SansSerif", 1, (int)((double)20 * puzzle.m_puzzleTextSize)));
            this.add(this.m_clock);
        }

        public void start() {
            this.m_done = false;
            this.m_running = true;
            if (this.m_puzzleClockThread == null) {
                this.m_puzzleClockThread = new Thread((Runnable)this, "PuzzleClock");
                this.startTime = System.currentTimeMillis();
                this.currentTime = System.currentTimeMillis();
                this.m_puzzleClockThread.start();
            } else {
                this.startTime = System.currentTimeMillis();
                this.currentTime = System.currentTimeMillis();
            }
        }

        public void run() {
            long l = System.currentTimeMillis();
            while (Thread.currentThread() == this.m_puzzleClockThread) {
                this.repaint();
                try {
                    Thread.sleep(Math.max(0L, (l += (long)1000) - System.currentTimeMillis()));
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }

        public void finish() {
            this.m_done = true;
            this.m_running = false;
        }

        public void paint(Graphics graphics) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (this.m_running) {
                if (!this.m_done) {
                    this.currentTime = System.currentTimeMillis();
                }
                int n5 = (int)(this.currentTime - this.startTime) / 1000;
                n = n5 / 60 / 60;
                n2 = n5 / 60 % 60;
                n3 = n5 % 60 / 10;
                n4 = n5 % 60 % 10;
                if (n == 0) {
                    this.m_clock.setText(String.valueOf(String.valueOf(new StringBuffer("").append(String.valueOf(n2)).append(":").append(String.valueOf(n3)).append(String.valueOf(n4)))));
                } else {
                    this.m_clock.setText(String.valueOf(String.valueOf(new StringBuffer("").append(String.valueOf(n)).append(":").append(String.valueOf(n2)).append(":").append(String.valueOf(n3)).append(String.valueOf(n4)))));
                }
            } else {
                this.m_clock.setText("0:00");
            }
            this.m_clock.invalidate();
            this.validate();
        }

        public void stop() {
            this.m_clock.setText("0:00");
            this.m_puzzleClockThread = null;
        }
    }

    abstract class PuzzlePanel
    extends Panel {
        Color m_backgroundColor;
        Color m_foregroundColor = Color.black;
        Color m_textColor;
        int m_width = 0;
        int m_height = 0;
        Image m_backbuffer;

        PuzzlePanel(Puzzle puzzle) {
            this.m_backgroundColor = Color.white;
            this.m_textColor = Color.black;
            if (System.getProperty("java.version").compareTo("1.4.0") >= 0) {
                this.setFocusTraversalKeysEnabled(false);
            }
        }

        public void backgroundColor(Color color) {
            this.m_backgroundColor = color;
        }

        public void foregroundColor(Color color) {
            this.m_foregroundColor = color;
        }

        public void textColor(Color color) {
            this.m_textColor = color;
        }

        public int convertX(int n) {
            return n;
        }

        public int convertY(int n) {
            return n;
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            this.m_backbuffer = this.createImage(dimension.width, dimension.height);
            this.m_width = dimension.width;
            this.m_height = dimension.height;
        }
    }

    class ImagePanel
    extends Panel {
        ImagePanel() {
        }

        public void paint(Graphics graphics) {
            if (Puzzle.this.m_puzzleBackgroundImage != "") {
                graphics.drawImage(Puzzle.this.m_image, 0, 0, null);
            }
        }
    }

    class PuzzleCharacter {
        char m_character;

        PuzzleCharacter(Puzzle puzzle) {
            this.m_character = '\u0000';
        }

        PuzzleCharacter(Puzzle puzzle, char c) {
            this.m_character = c;
        }

        char character() {
            return this.m_character;
        }
    }
}

