/*
 * Decompiled with CFR 0.152.
 */
package VarietyGames.CrosswordWeaverLive;

import VarietyGames.CrosswordWeaverLive.EntryStatus;
import VarietyGames.CrosswordWeaverLive.GridStatus;
import VarietyGames.CrosswordWeaverLive.Puzzle;
import VarietyGames.CrosswordWeaverLive.PuzzleGrid;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

class PuzzleCrossword
extends PuzzleGrid
implements ActionListener,
ItemListener,
KeyListener,
MouseListener {
    boolean m_forceUpperCase = false;
    boolean m_allowRestart = false;
    boolean m_allowCheck = false;
    boolean m_allowRevealWord = false;
    boolean m_allowRevealLetter = false;
    boolean m_allowSolve = false;
    Vector m_acrossStrings = new Vector();
    Vector m_downStrings = new Vector();
    Color m_primarySelectionColor = Color.decode("#FFFF00");
    Color m_secondarySelectionColor = Color.decode("#DDDDCC");
    Vector m_acrossClues = new Vector();
    Vector m_downClues = new Vector();
    PuzzleCrosswordEntry[][] m_entry;
    boolean m_editAcross = true;
    boolean m_firstKey = true;
    boolean m_deletePrevious = true;
    boolean m_completed = false;
    boolean m_runCompleteAnimation = false;
    Puzzle.PuzzleAnimator m_completeAnimator;
    List m_ui_acrossList;
    List m_ui_downList;
    Button m_ui_checkButton;
    Button m_ui_clearButton;
    Button m_ui_revealWordButton;
    Button m_ui_revealLetterButton;
    Button m_ui_solveButton;
    Label m_completeLabel;
    Label m_acrossClue;
    Label m_downClue;
    Label aLabel;
    Label dLabel;

    public PuzzleCrossword(String string) {
        super(string);
    }

    public void init() {
        super.init();
        this.m_entry = new PuzzleCrosswordEntry[this.m_gridWidth][this.m_gridHeight];
        this.clearPuzzle();
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        for (int i = 0; i < this.m_gridHeight; ++i) {
            for (int j = 0; j < this.m_gridWidth; ++j) {
                if (this.m_grid[j][i].gridStatus() != GridStatus.LETTER) continue;
                boolean bl = false;
                if ((j == 0 || this.m_grid[j - 1][i].gridStatus() != GridStatus.LETTER && this.m_grid[j - 1][i].gridStatus() != GridStatus.HINT) && n < this.m_acrossStrings.size() && j < this.m_gridWidth - 1 && (this.m_grid[j + 1][i].gridStatus() == GridStatus.LETTER || this.m_grid[j + 1][i].gridStatus() == GridStatus.HINT)) {
                    this.m_acrossClues.addElement(new CrosswordClue(this, j, i, (String)this.m_acrossStrings.elementAt(n), n3));
                    ++n;
                    bl = true;
                }
                if ((i == 0 || this.m_grid[j][i - 1].gridStatus() != GridStatus.LETTER && this.m_grid[j][i - 1].gridStatus() != GridStatus.HINT) && n2 < this.m_downStrings.size() && i < this.m_gridHeight - 1 && (this.m_grid[j][i + 1].gridStatus() == GridStatus.LETTER || this.m_grid[j][i + 1].gridStatus() == GridStatus.HINT)) {
                    this.m_downClues.addElement(new CrosswordClue(this, j, i, (String)this.m_downStrings.elementAt(n2), n3));
                    ++n2;
                    bl = true;
                }
                if (!bl) continue;
                ++n3;
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (keyEvent.getKeyCode()) {
            case 37: {
                keyEvent.consume();
                this.m_deletePrevious = false;
                if (!this.m_editAcross) {
                    this.swapEditDirection();
                    break;
                }
                this.leftBlock();
                this.swapEditDirection();
                this.swapEditDirection();
                break;
            }
            case 39: {
                keyEvent.consume();
                this.m_deletePrevious = false;
                if (!this.m_editAcross) {
                    this.swapEditDirection();
                    break;
                }
                this.rightBlock();
                this.swapEditDirection();
                this.swapEditDirection();
                break;
            }
            case 38: {
                keyEvent.consume();
                this.m_deletePrevious = false;
                if (this.m_editAcross) {
                    this.swapEditDirection();
                    break;
                }
                this.upBlock();
                this.swapEditDirection();
                this.swapEditDirection();
                break;
            }
            case 40: {
                keyEvent.consume();
                this.m_deletePrevious = false;
                if (this.m_editAcross) {
                    this.swapEditDirection();
                    break;
                }
                this.downBlock();
                this.swapEditDirection();
                this.swapEditDirection();
                break;
            }
            case 10: {
                this.swapEditDirection();
                keyEvent.consume();
                this.m_deletePrevious = false;
                break;
            }
            case 9: {
                if (keyEvent.isShiftDown()) {
                    this.previousWord();
                } else {
                    this.nextWord();
                }
                keyEvent.consume();
                this.m_deletePrevious = false;
                break;
            }
            case 8: {
                if (this.m_deletePrevious) {
                    this.previousBlock();
                    this.m_entry[this.m_selectedX][this.m_selectedY] = new PuzzleCrosswordEntry(this, '\u0000', EntryStatus.EMPTY);
                } else {
                    this.m_entry[this.m_selectedX][this.m_selectedY] = new PuzzleCrosswordEntry(this, '\u0000', EntryStatus.EMPTY);
                }
                this.m_deletePrevious = true;
                keyEvent.consume();
                break;
            }
            case 127: 
            case 155: {
                this.m_entry[this.m_selectedX][this.m_selectedY] = new PuzzleCrosswordEntry(this, '\u0000', EntryStatus.EMPTY);
                keyEvent.consume();
                this.m_deletePrevious = true;
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            case 32: {
                this.m_entry[this.m_selectedX][this.m_selectedY] = new PuzzleCrosswordEntry(this, '\u0000', EntryStatus.EMPTY);
                this.nextBlock();
                keyEvent.consume();
                break;
            }
        }
        this.chooseWords();
        this.repaint();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (Character.isLetterOrDigit(c) && this.m_selectedX >= 0 && this.m_selectedX < this.m_gridWidth && this.m_selectedY >= 0 && this.m_selectedY <= this.m_gridHeight) {
            this.m_entry[this.m_selectedX][this.m_selectedY] = this.m_forceUpperCase ? new PuzzleCrosswordEntry(this, Character.toUpperCase(c), EntryStatus.LETTER) : new PuzzleCrosswordEntry(this, c, EntryStatus.LETTER);
            this.nextBlock();
            this.swapEditDirection();
            this.swapEditDirection();
            if (this.m_firstKey && this.m_puzzleUseClock) {
                this.m_firstKey = false;
                if (this.m_puzzleClock != null) {
                    this.m_puzzleClock.start();
                }
            }
            this.m_deletePrevious = true;
            this.chooseWords();
            this.testPuzzleCompletion();
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        n = this.m_puzzlePanel.convertX(n);
        n2 = this.m_puzzlePanel.convertY(n2);
        if (n >= 0 && n <= this.m_gridWidth && n2 >= 0 && n2 < this.m_gridHeight && this.m_grid[n][n2].gridStatus() == GridStatus.LETTER) {
            if (n == this.m_selectedX && n2 == this.m_selectedY) {
                this.swapEditDirection();
            }
            this.m_selectedX = n;
            this.m_selectedY = n2;
            this.swapEditDirection();
            this.swapEditDirection();
            this.m_deletePrevious = false;
            this.chooseWords();
        }
        mouseEvent.consume();
        this.requestFocus();
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.m_ui_acrossList) {
            int n = this.m_ui_acrossList.getSelectedIndex();
            this.selectWord(n);
        } else if (itemEvent.getSource() == this.m_ui_downList) {
            int n = this.m_ui_downList.getSelectedIndex();
            this.selectWord(n + this.m_acrossClues.size());
        }
        this.chooseWords();
        this.requestFocus();
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_ui_checkButton) {
            for (int i = 0; i < this.m_gridHeight; ++i) {
                for (int j = 0; j < this.m_gridWidth; ++j) {
                    if (this.m_entry[j][i].entryStatus() != EntryStatus.EMPTY && Character.toUpperCase(this.m_entry[j][i].character()) != Character.toUpperCase(this.m_grid[j][i].character())) {
                        this.m_entry[j][i] = new PuzzleCrosswordEntry(this, this.m_entry[j][i].character(), EntryStatus.INCORRECT);
                        continue;
                    }
                    if (this.m_entry[j][i].entryStatus() == EntryStatus.REVEALED) continue;
                    this.m_entry[j][i] = new PuzzleCrosswordEntry(this, this.m_entry[j][i].character(), EntryStatus.REVEALED);
                }
            }
        } else if (actionEvent.getSource() == this.m_ui_clearButton) {
            this.clearPuzzle();
            this.m_firstKey = true;
            if (this.m_puzzleClock != null) {
                this.m_puzzleClock.stop();
            }
        } else if (actionEvent.getSource() == this.m_ui_revealLetterButton) {
            this.m_entry[this.m_selectedX][this.m_selectedY] = new PuzzleCrosswordEntry(this, this.m_grid[this.m_selectedX][this.m_selectedY].character(), EntryStatus.REVEALED);
            if (this.m_firstKey && this.m_puzzleUseClock) {
                this.m_firstKey = false;
                if (this.m_puzzleClock != null) {
                    this.m_puzzleClock.start();
                }
            }
        } else if (actionEvent.getSource() == this.m_ui_revealWordButton) {
            for (int i = 0; i < this.m_gridHeight; ++i) {
                for (int j = 0; j < this.m_gridWidth; ++j) {
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    if (i == this.m_selectedY && this.m_editAcross) {
                        n4 = j;
                        n3 = this.m_selectedX;
                        if (n4 > n3) {
                            n2 = n4;
                            n4 = n3;
                            n3 = n2;
                        }
                        n2 = 1;
                        for (n = n4; n < n3; ++n) {
                            if (this.m_grid[n][i].gridStatus() == GridStatus.LETTER) continue;
                            n2 = 0;
                        }
                        if (n2 == 0) continue;
                        this.m_entry[j][i] = new PuzzleCrosswordEntry(this, this.m_grid[j][i].character(), EntryStatus.REVEALED);
                        continue;
                    }
                    if (j != this.m_selectedX || this.m_editAcross) continue;
                    n4 = i;
                    n3 = this.m_selectedY;
                    if (n4 > n3) {
                        n2 = n4;
                        n4 = n3;
                        n3 = n2;
                    }
                    n2 = 1;
                    for (n = n4; n < n3; ++n) {
                        if (this.m_grid[j][n].gridStatus() == GridStatus.LETTER) continue;
                        n2 = 0;
                    }
                    if (n2 == 0) continue;
                    this.m_entry[j][i] = new PuzzleCrosswordEntry(this, this.m_grid[j][i].character(), EntryStatus.REVEALED);
                }
            }
            if (this.m_firstKey && this.m_puzzleUseClock) {
                this.m_firstKey = false;
                if (this.m_puzzleClock != null) {
                    this.m_puzzleClock.start();
                }
            }
        } else if (actionEvent.getSource() == this.m_ui_solveButton) {
            for (int i = 0; i < this.m_gridHeight; ++i) {
                for (int j = 0; j < this.m_gridWidth; ++j) {
                    if (this.m_entry[j][i].character() != this.m_grid[j][i].character()) {
                        this.m_entry[j][i] = new PuzzleCrosswordEntry(this, this.m_grid[j][i].character(), EntryStatus.REVEALED);
                        continue;
                    }
                    if (this.m_entry[j][i].entryStatus() == EntryStatus.REVEALED) continue;
                    this.m_entry[j][i] = new PuzzleCrosswordEntry(this, this.m_entry[j][i].character(), EntryStatus.REVEALED);
                }
            }
            if (this.m_firstKey && this.m_puzzleUseClock) {
                this.m_firstKey = false;
                if (this.m_puzzleClock != null) {
                    this.m_puzzleClock.start();
                }
            }
        }
        this.testPuzzleCompletion();
        this.requestFocus();
        this.repaint();
    }

    void swapEditDirection() {
        boolean bl = false;
        if (!this.m_editAcross) {
            if (this.m_selectedX > 0 && (this.m_grid[this.m_selectedX - 1][this.m_selectedY].gridStatus() == GridStatus.LETTER || this.m_grid[this.m_selectedX - 1][this.m_selectedY].gridStatus() == GridStatus.HINT)) {
                bl = true;
            }
            if (this.m_selectedX < this.m_gridWidth - 1 && (this.m_grid[this.m_selectedX + 1][this.m_selectedY].gridStatus() == GridStatus.LETTER || this.m_grid[this.m_selectedX + 1][this.m_selectedY].gridStatus() == GridStatus.HINT)) {
                bl = true;
            }
        }
        if (this.m_editAcross) {
            if (this.m_selectedY > 0 && (this.m_grid[this.m_selectedX][this.m_selectedY - 1].gridStatus() == GridStatus.LETTER || this.m_grid[this.m_selectedX][this.m_selectedY - 1].gridStatus() == GridStatus.HINT)) {
                bl = true;
            }
            if (this.m_selectedY < this.m_gridHeight - 1 && (this.m_grid[this.m_selectedX][this.m_selectedY + 1].gridStatus() == GridStatus.LETTER || this.m_grid[this.m_selectedX][this.m_selectedY + 1].gridStatus() == GridStatus.HINT)) {
                bl = true;
            }
        }
        if (bl) {
            this.m_editAcross = !this.m_editAcross;
        }
    }

    public void parseAttribute(String string, String string2) {
        if (string.equals("CrosswordAcrossClue") || string.equals("CWA")) {
            this.m_acrossStrings.addElement(string2);
        } else if (string.equals("CrosswordDownClue") || string.equals("CWD")) {
            this.m_downStrings.addElement(string2);
        } else if (string.equals("CrosswordAllowRestart") || string.equals("CWRestart")) {
            if (string2.equalsIgnoreCase("True")) {
                this.m_allowRestart = true;
            }
        } else if (string.equals("CrosswordAllowCheck") || string.equals("CWCheck")) {
            if (string2.equalsIgnoreCase("True")) {
                this.m_allowCheck = true;
            }
        } else if (string.equals("CrosswordAllowRevealWord") || string.equals("CWRevealW")) {
            if (string2.equalsIgnoreCase("True")) {
                this.m_allowRevealWord = true;
            }
        } else if (string.equals("CrosswordAllowRevealLetter") || string.equals("CWRevealL")) {
            if (string2.equalsIgnoreCase("True")) {
                this.m_allowRevealLetter = true;
            }
        } else if (string.equals("CrosswordAllowSolve") || string.equals("CWSolve")) {
            if (string2.equalsIgnoreCase("True")) {
                this.m_allowSolve = true;
            }
        } else if (string.equals("CrosswordForceUpperCase") || string.equals("CWUpperCase")) {
            if (string2.equalsIgnoreCase("True")) {
                this.m_forceUpperCase = true;
            }
        } else {
            super.parseAttribute(string, string2);
        }
    }

    public Panel createUI() {
        int n;
        Panel panel;
        Panel panel2;
        Component component;
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        panel3.setBackground(this.m_puzzleBackgroundColor);
        panel3.setForeground(this.m_puzzleTextColor);
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout());
        Panel panel5 = new Panel();
        panel5.setLayout(new BorderLayout());
        this.m_puzzlePanel = new PuzzleCrosswordPanel();
        Panel panel6 = new Panel();
        panel6.setLayout(new BorderLayout());
        panel6.add((Component)this.m_puzzlePanel, "Center");
        panel5.add((Component)panel6, "Center");
        panel4.add((Component)panel5, "Center");
        Panel panel7 = new Panel();
        panel4.add((Component)panel7, "North");
        Panel panel8 = new Panel();
        panel8.setLayout(new BorderLayout());
        panel3.add((Component)panel8, "South");
        Panel panel9 = new Panel();
        int n2 = 0;
        if (this.m_allowRestart) {
            ++n2;
        }
        if (this.m_allowRevealLetter) {
            ++n2;
        }
        if (this.m_allowRevealWord) {
            ++n2;
        }
        if (this.m_allowCheck) {
            ++n2;
        }
        if (this.m_allowSolve) {
            ++n2;
        }
        if (n2 > 0) {
            panel9.setLayout(new Puzzle.BetterFlowLayout(this));
        } else {
            panel9.setLayout(new BorderLayout());
        }
        panel8.add((Component)panel9, "Center");
        panel7.setLayout(new FlowLayout());
        if (!this.m_puzzleTitle.equals("")) {
            component = new Label();
            ((Label)component).setAlignment(0);
            component.setFont(new Font("Serif", 1, (int)((double)20 * this.m_puzzleTextSize)));
            ((Label)component).setText(this.m_puzzleTitle);
            panel7.add(component);
        }
        if (!this.m_puzzleAuthor.equals("")) {
            component = new Label();
            ((Label)component).setAlignment(0);
            component.setFont(new Font("SansSerif", 0, (int)((double)16 * this.m_puzzleTextSize)));
            ((Label)component).setText(this.m_puzzleAuthor);
            panel7.add(component);
        }
        if (!this.m_puzzleDate.equals("")) {
            component = new Label();
            ((Label)component).setAlignment(0);
            component.setFont(new Font("SansSerif", 0, (int)((double)16 * this.m_puzzleTextSize)));
            ((Label)component).setText(this.m_puzzleDate);
            panel7.add(component);
        }
        if (!this.m_puzzleCopyright.equals("")) {
            component = new Label();
            ((Label)component).setAlignment(0);
            component.setFont(new Font("SansSerif", 0, (int)((double)10 * this.m_puzzleTextSize)));
            ((Label)component).setText(this.m_puzzleCopyright);
            panel6.add(component, "South");
        }
        this.m_ui_clearButton = new Button();
        if (this.m_allowRestart) {
            this.m_ui_clearButton.setLabel("Restart Puzzle");
            this.m_ui_clearButton.setFont(new Font("SansSerif", 0, (int)((double)12 * this.m_puzzleTextSize)));
            this.m_ui_clearButton.setForeground(this.m_puzzleButtonTextColor);
            this.m_ui_clearButton.setBackground(this.m_puzzleButtonColor);
            this.m_ui_clearButton.addActionListener(this);
            panel9.add(this.m_ui_clearButton);
        }
        this.m_ui_revealLetterButton = new Button();
        if (this.m_allowRevealLetter) {
            this.m_ui_revealLetterButton.setLabel("Reveal Letter");
            this.m_ui_revealLetterButton.setFont(new Font("SansSerif", 0, (int)((double)12 * this.m_puzzleTextSize)));
            this.m_ui_revealLetterButton.setForeground(this.m_puzzleButtonTextColor);
            this.m_ui_revealLetterButton.setBackground(this.m_puzzleButtonColor);
            this.m_ui_revealLetterButton.addActionListener(this);
            panel9.add(this.m_ui_revealLetterButton);
        }
        this.m_ui_revealWordButton = new Button();
        if (this.m_allowRevealWord) {
            this.m_ui_revealWordButton.setLabel("Reveal Word");
            this.m_ui_revealWordButton.setFont(new Font("SansSerif", 0, (int)((double)12 * this.m_puzzleTextSize)));
            this.m_ui_revealWordButton.setForeground(this.m_puzzleButtonTextColor);
            this.m_ui_revealWordButton.setBackground(this.m_puzzleButtonColor);
            this.m_ui_revealWordButton.addActionListener(this);
            panel9.add(this.m_ui_revealWordButton);
        }
        this.m_ui_checkButton = new Button();
        if (this.m_allowCheck) {
            this.m_ui_checkButton.setLabel("Check");
            this.m_ui_checkButton.setFont(new Font("SansSerif", 0, (int)((double)12 * this.m_puzzleTextSize)));
            this.m_ui_checkButton.setForeground(this.m_puzzleButtonTextColor);
            this.m_ui_checkButton.setBackground(this.m_puzzleButtonColor);
            this.m_ui_checkButton.addActionListener(this);
            panel9.add(this.m_ui_checkButton);
        }
        this.m_ui_solveButton = new Button();
        if (this.m_allowSolve) {
            this.m_ui_solveButton.setLabel("Solve");
            this.m_ui_solveButton.setFont(new Font("SansSerif", 0, (int)((double)12 * this.m_puzzleTextSize)));
            this.m_ui_solveButton.setForeground(this.m_puzzleButtonTextColor);
            this.m_ui_solveButton.setBackground(this.m_puzzleButtonColor);
            this.m_ui_solveButton.addActionListener(this);
            panel9.add(this.m_ui_solveButton);
        }
        if (this.m_puzzleUseClock) {
            this.m_puzzleClock = new Puzzle.PuzzleClock(this);
            this.m_puzzleClock.setFont(new Font("SansSerif", 0, (int)((double)20 * this.m_puzzleTextSize)));
            panel9.add(this.m_puzzleClock);
        }
        component = new Panel();
        ((Container)component).setLayout(new BorderLayout());
        this.m_ui_acrossList = new Puzzle.WrappedList();
        this.m_ui_acrossList.setFont(new Font("SansSerif", 0, (int)((double)12 * this.m_puzzleTextSize)));
        this.m_ui_acrossList.setForeground(this.m_puzzleClueTextColor);
        this.m_ui_acrossList.setBackground(this.m_puzzleClueColor);
        Panel panel10 = new Panel();
        panel10.setLayout(new BorderLayout());
        Label label = new Label();
        label.setFont(new Font("SansSerif", 1, (int)((double)14 * this.m_puzzleTextSize)));
        label.setAlignment(0);
        label.setText("Across");
        panel10.add((Component)label, "Center");
        Label label2 = new Label();
        label2.setForeground(this.m_puzzleBackgroundColor);
        label2.setFont(new Font("SansSerif", 1, (int)((double)14 * this.m_puzzleTextSize)));
        label2.setText("Clues Clues Clues");
        panel10.add((Component)label2, "East");
        ((Container)component).add(this.m_ui_acrossList, "Center");
        ((Container)component).add(panel10, "North");
        Panel panel11 = new Panel();
        panel11.setLayout(new BorderLayout());
        this.m_ui_downList = new Puzzle.WrappedList();
        this.m_ui_downList.setFont(new Font("SansSerif", 0, (int)((double)12 * this.m_puzzleTextSize)));
        this.m_ui_downList.setForeground(this.m_puzzleClueTextColor);
        this.m_ui_downList.setBackground(this.m_puzzleClueColor);
        Panel panel12 = new Panel();
        panel12.setLayout(new BorderLayout());
        Label label3 = new Label();
        label3.setFont(new Font("SansSerif", 1, (int)((double)14 * this.m_puzzleTextSize)));
        label3.setAlignment(0);
        label3.setText("Down");
        Label label4 = new Label();
        label4.setForeground(this.m_puzzleBackgroundColor);
        label4.setFont(new Font("SansSerif", 1, (int)((double)14 * this.m_puzzleTextSize)));
        label4.setText("Clues Clues Clues");
        panel12.add((Component)label4, "East");
        panel12.add((Component)label3, "Center");
        panel11.add((Component)this.m_ui_downList, "Center");
        panel11.add((Component)panel12, "North");
        panel3.add((Component)panel4, "Center");
        this.m_acrossClue = new Label("");
        this.m_downClue = new Label("");
        this.m_acrossClue.setFont(new Font("SansSerif", 1, (int)((double)14 * this.m_puzzleTextSize)));
        this.m_downClue.setFont(new Font("SansSerif", 1, (int)((double)14 * this.m_puzzleTextSize)));
        this.aLabel = new Label("Across:");
        this.dLabel = new Label("Down:");
        if (this.m_puzzleLayout == 0) {
            panel2 = new Panel();
            panel2.setLayout(new BorderLayout());
            panel = new Panel();
            panel.setLayout(new GridLayout(0, 1));
            panel.add(component);
            panel.add(panel11);
            panel2.add((Component)panel, "Center");
            panel5.add((Component)panel2, "East");
            panel.invalidate();
            panel2.invalidate();
        } else if (this.m_puzzleLayout == 1) {
            panel5.add(component, "West");
            panel5.add((Component)panel11, "East");
        } else if (this.m_puzzleLayout == 2) {
            panel2 = new Panel();
            panel2.setLayout(new BorderLayout());
            panel = new Panel();
            panel.setLayout(new GridLayout(0, 1));
            panel.add(component);
            panel.add(panel11);
            panel2.add((Component)panel, "Center");
            panel5.add((Component)panel2, "West");
            panel.invalidate();
            panel2.invalidate();
        } else if (this.m_puzzleLayout == 3) {
            panel2 = new Panel();
            panel2.setLayout(new BorderLayout());
            panel = new Panel();
            panel.setLayout(new GridLayout(0, 1));
            Panel panel13 = new Panel();
            panel13.setLayout(new GridLayout(0, 1));
            panel.add((Component)this.m_acrossClue, "North");
            panel.add((Component)this.m_downClue, "South");
            this.aLabel.setFont(new Font("SansSerif", 0, (int)((double)14 * this.m_puzzleTextSize)));
            this.dLabel.setFont(new Font("SansSerif", 0, (int)((double)14 * this.m_puzzleTextSize)));
            panel13.add(this.aLabel);
            panel13.add(this.dLabel);
            panel2.add((Component)panel, "Center");
            panel2.add((Component)panel13, "West");
            panel3.add((Component)panel2, "North");
        }
        for (n = 0; n < this.m_acrossClues.size(); ++n) {
            this.m_ui_acrossList.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(((CrosswordClue)this.m_acrossClues.elementAt(n)).number()))).append(". ").append(((CrosswordClue)this.m_acrossClues.elementAt(n)).clue()))));
        }
        for (n = 0; n < this.m_downClues.size(); ++n) {
            this.m_ui_downList.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(((CrosswordClue)this.m_downClues.elementAt(n)).number()))).append(". ").append(((CrosswordClue)this.m_downClues.elementAt(n)).clue()))));
        }
        this.m_ui_acrossList.invalidate();
        this.m_ui_downList.invalidate();
        this.m_puzzlePanel.invalidate();
        panel3.invalidate();
        panel3.validate();
        this.m_puzzlePanel.addMouseListener(this);
        this.m_puzzlePanel.addKeyListener(this);
        this.m_ui_checkButton.addActionListener(this);
        this.m_ui_clearButton.addActionListener(this);
        this.m_ui_revealLetterButton.addActionListener(this);
        this.m_ui_revealWordButton.addActionListener(this);
        this.m_ui_acrossList.addItemListener(this);
        this.m_ui_downList.addItemListener(this);
        this.requestFocus();
        return panel3;
    }

    void upBlock() {
        int n = this.m_selectedX;
        int n2 = this.m_selectedY;
        do {
            --this.m_selectedY;
            if (this.m_selectedY >= 0) continue;
            this.m_selectedY = this.m_gridHeight - 1;
        } while (this.m_grid[this.m_selectedX][this.m_selectedY].gridStatus() != GridStatus.LETTER && (this.m_selectedX != n || this.m_selectedY != n2));
    }

    void downBlock() {
        int n = this.m_selectedX;
        int n2 = this.m_selectedY;
        do {
            ++this.m_selectedY;
            if (this.m_selectedY < this.m_gridHeight) continue;
            this.m_selectedY = 0;
        } while (this.m_grid[this.m_selectedX][this.m_selectedY].gridStatus() != GridStatus.LETTER && (this.m_selectedX != n || this.m_selectedY != n2));
    }

    void leftBlock() {
        int n = this.m_selectedX;
        int n2 = this.m_selectedY;
        do {
            --this.m_selectedX;
            if (this.m_selectedX < 0) {
                this.m_selectedX = this.m_gridWidth - 1;
                --this.m_selectedY;
            }
            if (this.m_selectedY >= 0) continue;
            this.m_selectedY = this.m_gridHeight - 1;
        } while (this.m_grid[this.m_selectedX][this.m_selectedY].gridStatus() != GridStatus.LETTER && (this.m_selectedX != n || this.m_selectedY != n2));
    }

    void rightBlock() {
        int n = this.m_selectedX;
        int n2 = this.m_selectedY;
        do {
            ++this.m_selectedX;
            if (this.m_selectedX >= this.m_gridWidth) {
                this.m_selectedX = 0;
                ++this.m_selectedY;
            }
            if (this.m_selectedY < this.m_gridHeight) continue;
            this.m_selectedY = 0;
        } while (this.m_grid[this.m_selectedX][this.m_selectedY].gridStatus() != GridStatus.LETTER && (this.m_selectedX != n || this.m_selectedY != n2));
    }

    void nextBlock() {
        if (this.m_editAcross) {
            if (this.m_selectedX >= this.m_gridWidth - 1 || this.m_grid[this.m_selectedX + 1][this.m_selectedY].gridStatus() != GridStatus.LETTER) {
                this.nextWord();
            } else {
                this.rightBlock();
            }
        } else if (this.m_selectedY >= this.m_gridHeight - 1 || this.m_grid[this.m_selectedX][this.m_selectedY + 1].gridStatus() != GridStatus.LETTER) {
            this.nextWord();
        } else {
            this.downBlock();
        }
    }

    void previousBlock() {
        block9: {
            boolean bl;
            block8: {
                bl = false;
                if (this.m_editAcross) {
                    if (this.m_selectedX <= 0 || this.m_grid[this.m_selectedX - 1][this.m_selectedY].gridStatus() != GridStatus.LETTER) {
                        this.previousWord();
                        bl = true;
                    } else {
                        this.leftBlock();
                    }
                } else if (this.m_selectedY <= 0 || this.m_grid[this.m_selectedX][this.m_selectedY - 1].gridStatus() != GridStatus.LETTER) {
                    this.previousWord();
                    bl = true;
                } else {
                    this.upBlock();
                }
                if (!bl || !this.m_editAcross) break block8;
                while (this.m_selectedX < this.m_gridWidth - 1 && this.m_grid[this.m_selectedX + 1][this.m_selectedY].gridStatus() == GridStatus.LETTER) {
                    ++this.m_selectedX;
                }
                break block9;
            }
            if (!bl || this.m_editAcross) break block9;
            while (this.m_selectedY < this.m_gridHeight - 1 && this.m_grid[this.m_selectedX][this.m_selectedY + 1].gridStatus() == GridStatus.LETTER) {
                ++this.m_selectedY;
            }
        }
    }

    int wordIndex(int n, int n2) {
        int n3 = -1;
        int n4 = 0;
        if (n >= 0 && n < this.m_gridWidth && n2 >= 0 && n2 < this.m_gridHeight && (this.m_grid[n][n2].gridStatus() == GridStatus.LETTER || this.m_grid[n][n2].gridStatus() == GridStatus.HINT)) {
            if (this.m_editAcross) {
                int n5;
                for (n5 = 0; n5 < this.m_acrossClues.size(); ++n5) {
                    if (((CrosswordClue)this.m_acrossClues.elementAt(n5)).y() != n2 || ((CrosswordClue)this.m_acrossClues.elementAt(n5)).x() > n || ((CrosswordClue)this.m_acrossClues.elementAt(n5)).x() < n4) continue;
                    n4 = ((CrosswordClue)this.m_acrossClues.elementAt(n5)).x();
                    n3 = n5;
                }
                if (n3 >= 0) {
                    for (n5 = n4; n5 <= n; ++n5) {
                        if (this.m_grid[n5][n2].gridStatus() != GridStatus.REMOVED) continue;
                        n3 = -1;
                    }
                }
            } else {
                int n6;
                for (n6 = 0; n6 < this.m_downClues.size(); ++n6) {
                    if (((CrosswordClue)this.m_downClues.elementAt(n6)).x() != n || ((CrosswordClue)this.m_downClues.elementAt(n6)).y() > n2 || ((CrosswordClue)this.m_downClues.elementAt(n6)).y() < n4) continue;
                    n4 = ((CrosswordClue)this.m_downClues.elementAt(n6)).y();
                    n3 = n6;
                }
                if (n3 >= 0) {
                    for (n6 = n4; n6 <= n2; ++n6) {
                        if (this.m_grid[n][n6].gridStatus() != GridStatus.REMOVED) continue;
                        n3 = -1;
                    }
                }
                if (n3 >= 0) {
                    n3 += this.m_acrossClues.size();
                }
            }
        }
        return n3;
    }

    int currentWord() {
        return this.wordIndex(this.m_selectedX, this.m_selectedY);
    }

    void nextWord() {
        int n = this.currentWord();
        if (++n >= this.m_acrossClues.size() + this.m_downClues.size()) {
            n = 0;
        }
        this.selectWord(n);
    }

    void previousWord() {
        int n = this.currentWord();
        if (--n < 0) {
            n = this.m_acrossClues.size() + this.m_downClues.size() - 1;
        }
        this.selectWord(n);
    }

    void selectWord(int n) {
        if (n < this.m_acrossClues.size()) {
            this.m_selectedX = ((CrosswordClue)this.m_acrossClues.elementAt(n)).x();
            this.m_selectedY = ((CrosswordClue)this.m_acrossClues.elementAt(n)).y();
            this.m_editAcross = true;
        } else if ((n -= this.m_acrossClues.size()) < this.m_downClues.size()) {
            this.m_selectedX = ((CrosswordClue)this.m_downClues.elementAt(n)).x();
            this.m_selectedY = ((CrosswordClue)this.m_downClues.elementAt(n)).y();
            this.m_editAcross = false;
        }
    }

    void testPuzzleCompletion() {
        int n = 0;
        int n2 = 0;
        if (!this.m_completed) {
            this.m_completed = true;
            for (n = 0; n < this.m_gridWidth; ++n) {
                for (n2 = 0; n2 < this.m_gridHeight; ++n2) {
                    if (this.m_grid[n][n2].gridStatus() != GridStatus.LETTER || Character.toUpperCase(this.m_entry[n][n2].character()) == Character.toUpperCase(this.m_grid[n][n2].character())) continue;
                    this.m_completed = false;
                }
            }
            if (this.m_completed) {
                this.m_completeAnimator = new Puzzle.PuzzleAnimator(0, 30);
                this.m_completeAnimator.start();
            }
        }
        if (this.m_completed && this.m_puzzleClock != null) {
            this.m_puzzleClock.finish();
        }
    }

    void clearPuzzle() {
        int n = 0;
        int n2 = 0;
        for (n = 0; n < this.m_gridWidth; ++n) {
            for (n2 = 0; n2 < this.m_gridHeight; ++n2) {
                this.m_entry[n][n2] = new PuzzleCrosswordEntry(this, '\u0000', EntryStatus.EMPTY);
            }
        }
    }

    void chooseWords() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        this.m_ui_acrossList.deselect(this.m_ui_acrossList.getSelectedIndex());
        this.m_ui_downList.deselect(this.m_ui_downList.getSelectedIndex());
        for (n5 = 0; n5 < this.m_acrossClues.size(); ++n5) {
            if (((CrosswordClue)this.m_acrossClues.elementAt(n5)).y() != this.m_selectedY) continue;
            n4 = ((CrosswordClue)this.m_acrossClues.elementAt(n5)).x();
            if (n4 > (n3 = this.m_selectedX)) {
                n2 = n4;
                n4 = n3;
                n3 = n2;
            }
            n2 = 1;
            for (n = n4; n < n3; ++n) {
                if (this.m_grid[n][this.m_selectedY].gridStatus() == GridStatus.LETTER) continue;
                n2 = 0;
            }
            if (n2 == 0) continue;
            n6 = n5;
        }
        if (this.m_editAcross) {
            this.m_ui_acrossList.select(n6);
            this.m_ui_acrossList.repaint();
            this.m_acrossClue.setBackground(this.m_primarySelectionColor);
            this.m_downClue.setBackground(this.m_puzzleBackgroundColor);
            this.aLabel.setBackground(this.m_primarySelectionColor);
            this.dLabel.setBackground(this.m_puzzleBackgroundColor);
        }
        this.m_ui_acrossList.makeVisible(n6);
        this.m_acrossClue.setText(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(((CrosswordClue)this.m_acrossClues.elementAt(n6)).number()))).append(". ").append(((CrosswordClue)this.m_acrossClues.elementAt(n6)).clue()))));
        n6 = 0;
        for (n5 = 0; n5 < this.m_downClues.size(); ++n5) {
            if (((CrosswordClue)this.m_downClues.elementAt(n5)).x() != this.m_selectedX) continue;
            n4 = ((CrosswordClue)this.m_downClues.elementAt(n5)).y();
            if (n4 > (n3 = this.m_selectedY)) {
                n2 = n4;
                n4 = n3;
                n3 = n2;
            }
            n2 = 1;
            for (n = n4; n < n3; ++n) {
                if (this.m_grid[this.m_selectedX][n].gridStatus() == GridStatus.LETTER) continue;
                n2 = 0;
            }
            if (n2 == 0) continue;
            n6 = n5;
        }
        if (!this.m_editAcross) {
            this.m_ui_downList.select(n6);
            this.m_ui_downList.repaint();
            this.m_downClue.setBackground(this.m_primarySelectionColor);
            this.m_acrossClue.setBackground(this.m_puzzleBackgroundColor);
            this.dLabel.setBackground(this.m_primarySelectionColor);
            this.aLabel.setBackground(this.m_puzzleBackgroundColor);
        }
        this.m_ui_downList.makeVisible(n6);
        this.m_downClue.setText(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(((CrosswordClue)this.m_downClues.elementAt(n6)).number()))).append(". ").append(((CrosswordClue)this.m_downClues.elementAt(n6)).clue()))));
    }

    void animate(int n, int n2) {
        if (n == 0) {
            if (n2 == 0) {
                int n3 = this.m_puzzlePanel.getSize().width;
                this.m_completeLabel = new Label("Puzzle Complete!");
                this.m_completeLabel.setFont(new Font("SansSerif", 1, n3 / 10));
                this.m_completeLabel.setAlignment(1);
                this.m_completeLabel.setBackground(Color.green);
                this.m_puzzlePanel.add((Component)this.m_completeLabel, "South");
                this.m_puzzlePanel.validate();
            }
            if (n2 == 60) {
                this.m_completeAnimator.stop();
                this.m_puzzlePanel.remove(this.m_completeLabel);
                this.m_puzzlePanel.validate();
            }
            this.repaint();
        }
    }

    class CrosswordClue {
        int m_x = 0;
        int m_y = 0;
        String m_clue;
        int m_number;

        CrosswordClue(PuzzleCrossword puzzleCrossword, int n, int n2, String string, int n3) {
            this.m_x = n;
            this.m_y = n2;
            this.m_clue = string;
            this.m_number = n3;
        }

        String clue() {
            return this.m_clue;
        }

        int x() {
            return this.m_x;
        }

        int y() {
            return this.m_y;
        }

        int number() {
            return this.m_number;
        }
    }

    class PuzzleCrosswordPanel
    extends PuzzleGrid.PuzzleGridPanel {
        int font_size = 0;

        PuzzleCrosswordPanel() {
            super(PuzzleCrossword.this);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            this.update(graphics);
        }

        public void update(Graphics graphics) {
            Graphics graphics2 = this.m_backbuffer.getGraphics();
            graphics2.setColor(PuzzleCrossword.this.m_gridBackgroundColor);
            graphics2.fillRect(0, 0, PuzzleCrossword.this.m_gridWidth * this.m_gridCellSize + PuzzleCrossword.this.m_shadowWidth + 1, PuzzleCrossword.this.m_gridHeight * this.m_gridCellSize + PuzzleCrossword.this.m_shadowWidth + 1);
            int n = PuzzleCrossword.this.m_gridWidth * this.m_gridCellSize + PuzzleCrossword.this.m_shadowWidth;
            float f = 0.0f;
            if (!PuzzleCrossword.this.registered() && this.font_size == 0) {
                while (f < (float)n) {
                    ++this.font_size;
                    Font font = new Font("SansSerif", 0, this.font_size);
                    FontMetrics fontMetrics = graphics2.getFontMetrics(font);
                    String string = "Sample*";
                    f = fontMetrics.charsWidth(string.toCharArray(), 0, string.length());
                }
            }
            int n2 = 0;
            int n3 = PuzzleCrossword.this.currentWord();
            int n4 = 0;
            int n5 = 0;
            for (n5 = 0; n5 < PuzzleCrossword.this.m_gridHeight; ++n5) {
                for (n4 = 0; n4 < PuzzleCrossword.this.m_gridWidth; ++n4) {
                    if (PuzzleCrossword.this.m_grid[n4][n5].gridStatus() != GridStatus.REMOVED) {
                        if (PuzzleCrossword.this.m_shadowWidth > 0) {
                            graphics2.setColor(PuzzleCrossword.this.m_gridBackgroundColor.darker());
                            graphics2.fillRect(n4 * this.m_gridCellSize + PuzzleCrossword.this.m_shadowWidth, n5 * this.m_gridCellSize + PuzzleCrossword.this.m_shadowWidth, this.m_gridCellSize + 1, this.m_gridCellSize + 1);
                        }
                        if (n4 == PuzzleCrossword.this.m_selectedX && n5 == PuzzleCrossword.this.m_selectedY) {
                            graphics2.setColor(PuzzleCrossword.this.m_primarySelectionColor);
                            graphics2.fillRect(n4 * this.m_gridCellSize, n5 * this.m_gridCellSize, this.m_gridCellSize + 1, this.m_gridCellSize + 1);
                        } else if (n3 >= 0 && PuzzleCrossword.this.wordIndex(n4, n5) == n3) {
                            graphics2.setColor(PuzzleCrossword.this.m_secondarySelectionColor);
                            graphics2.fillRect(n4 * this.m_gridCellSize, n5 * this.m_gridCellSize, this.m_gridCellSize + 1, this.m_gridCellSize + 1);
                        } else if (PuzzleCrossword.this.m_grid[n4][n5].gridStatus() == GridStatus.BLOCK) {
                            graphics2.setColor(this.m_foregroundColor);
                            graphics2.fillRect(n4 * this.m_gridCellSize, n5 * this.m_gridCellSize, this.m_gridCellSize + 1, this.m_gridCellSize + 1);
                        } else {
                            graphics2.setColor(this.m_backgroundColor);
                            graphics2.fillRect(n4 * this.m_gridCellSize, n5 * this.m_gridCellSize, this.m_gridCellSize + 1, this.m_gridCellSize + 1);
                        }
                    }
                    if (PuzzleCrossword.this.m_grid[n4][n5].gridStatus() != GridStatus.LETTER && PuzzleCrossword.this.m_grid[n4][n5].gridStatus() != GridStatus.HINT) continue;
                    graphics2.setColor(this.m_foregroundColor);
                    graphics2.drawRect(n4 * this.m_gridCellSize, n5 * this.m_gridCellSize, this.m_gridCellSize, this.m_gridCellSize);
                }
            }
            if (!PuzzleCrossword.this.registered()) {
                Font font = new Font("SansSerif", 0, this.font_size);
                graphics2.setFont(font);
                graphics2.setColor(Color.decode("#8888FF"));
                graphics2.drawString("Sample*", 0, this.m_gridCellSize * PuzzleCrossword.this.m_gridHeight / 2);
            }
            for (n5 = 0; n5 < PuzzleCrossword.this.m_gridHeight; ++n5) {
                for (n4 = 0; n4 < PuzzleCrossword.this.m_gridWidth; ++n4) {
                    int n6;
                    if (PuzzleCrossword.this.m_grid[n4][n5].gridStatus() != GridStatus.LETTER && PuzzleCrossword.this.m_grid[n4][n5].gridStatus() != GridStatus.HINT) continue;
                    char c = ' ';
                    c = PuzzleCrossword.this.m_grid[n4][n5].gridStatus() == GridStatus.LETTER ? (char)PuzzleCrossword.this.m_entry[n4][n5].character() : (char)PuzzleCrossword.this.m_grid[n4][n5].character();
                    Font font = new Font("SansSerif", 1, (int)((double)this.m_gridCellSize * 0.8));
                    graphics2.setFont(font);
                    FontMetrics fontMetrics = graphics2.getFontMetrics();
                    int n7 = fontMetrics.charWidth(c);
                    double d = (double)n7 / (double)this.m_gridCellSize;
                    d = 0.5 - d / 2.0;
                    if (PuzzleCrossword.this.m_entry[n4][n5].entryStatus() == EntryStatus.INCORRECT) {
                        graphics2.setColor(Color.red);
                    } else if (PuzzleCrossword.this.m_grid[n4][n5].gridStatus() == GridStatus.HINT) {
                        graphics2.setColor(Color.gray);
                    } else {
                        graphics2.setColor(this.m_textColor);
                    }
                    if (c != '\u0000') {
                        String string = "".concat(String.valueOf(String.valueOf(c)));
                        graphics2.drawString(string, (int)(((double)n4 + d) * (double)this.m_gridCellSize), (int)(((double)n5 + 0.9) * (double)this.m_gridCellSize));
                    }
                    boolean bl = false;
                    if ((n4 == 0 || PuzzleCrossword.this.m_grid[n4 - 1][n5].gridStatus() != GridStatus.LETTER && PuzzleCrossword.this.m_grid[n4 - 1][n5].gridStatus() != GridStatus.HINT) && n4 < PuzzleCrossword.this.m_gridWidth - 1 && (PuzzleCrossword.this.m_grid[n4 + 1][n5].gridStatus() == GridStatus.LETTER || PuzzleCrossword.this.m_grid[n4 + 1][n5].gridStatus() == GridStatus.HINT)) {
                        bl = true;
                        ++n2;
                    }
                    if (!(bl || n5 != 0 && (PuzzleCrossword.this.m_grid[n4][n5 - 1].gridStatus() == GridStatus.LETTER || PuzzleCrossword.this.m_grid[n4][n5 - 1].gridStatus() == GridStatus.HINT) || n5 >= PuzzleCrossword.this.m_gridHeight - 1 || PuzzleCrossword.this.m_grid[n4][n5 + 1].gridStatus() != GridStatus.LETTER && PuzzleCrossword.this.m_grid[n4][n5 + 1].gridStatus() != GridStatus.HINT)) {
                        bl = true;
                        ++n2;
                    }
                    if (!bl || (n6 = this.m_gridCellSize / 3) < 5) continue;
                    if (n6 > this.m_gridCellSize) {
                        n6 = this.m_gridCellSize;
                    }
                    Font font2 = new Font("Monospace", 0, n6);
                    graphics2.setFont(font2);
                    graphics2.setColor(PuzzleCrossword.this.m_clueNumberColor);
                    graphics2.drawString(Integer.toString(n2), (int)(((double)n4 + 0.1) * (double)this.m_gridCellSize), (int)(((float)n5 + (float)n6 / (float)this.m_gridCellSize) * (float)this.m_gridCellSize));
                }
            }
            graphics.drawImage(this.m_backbuffer, this.m_centerX, this.m_centerY, this);
        }
    }

    class PuzzleCrosswordEntry
    extends Puzzle.PuzzleCharacter {
        EntryStatus m_entryStatus;

        PuzzleCrosswordEntry(PuzzleCrossword puzzleCrossword, char c, EntryStatus entryStatus) {
            super(puzzleCrossword, c);
            this.m_entryStatus = entryStatus;
        }

        EntryStatus entryStatus() {
            return this.m_entryStatus;
        }
    }
}

