/*
 * Decompiled with CFR 0.152.
 */
package VarietyGames.CrosswordWeaverLive;

import VarietyGames.CrosswordWeaverLive.GridStatus;
import VarietyGames.CrosswordWeaverLive.Puzzle;
import java.awt.Color;
import java.awt.Graphics;

public abstract class PuzzleGrid
extends Puzzle {
    int m_gridWidth = 0;
    int m_gridHeight = 0;
    int m_shadowWidth = 0;
    String m_gridString = "";
    int m_gridChecksum = 0;
    Color m_gridBackgroundColor = Color.white;
    PuzzleGridCell[][] m_grid;
    int m_selectedX = -1;
    int m_selectedY = -1;

    public PuzzleGrid(String string) {
        super(string);
    }

    public void init() {
        super.init();
        if (this.m_gridWidth < 0) {
            this.m_gridWidth = 0;
        }
        if (this.m_gridHeight < 0) {
            this.m_gridHeight = 0;
        }
        this.m_grid = new PuzzleGridCell[this.m_gridWidth][this.m_gridHeight];
        for (int i = 0; i < this.m_gridHeight; ++i) {
            for (int j = 0; j < this.m_gridWidth; ++j) {
                char c = '\u0000';
                char c2 = '\u0000';
                if ((i * this.m_gridWidth + j) * 2 + 0 < this.m_gridString.length()) {
                    c = this.m_gridString.charAt((i * this.m_gridWidth + j) * 2 + 0);
                }
                if ((i * this.m_gridWidth + j) * 2 + 1 < this.m_gridString.length()) {
                    c2 = this.m_gridString.charAt((i * this.m_gridWidth + j) * 2 + 1);
                }
                this.m_grid[j][i] = c == '1' ? new PuzzleGridCell(this, c2, GridStatus.LETTER) : (c == '2' ? new PuzzleGridCell(this, c2, GridStatus.BLOCK) : (c == '3' ? new PuzzleGridCell(this, c2, GridStatus.HINT) : new PuzzleGridCell(this, c2, GridStatus.REMOVED)));
            }
        }
    }

    public void parseAttribute(String string, String string2) {
        if (string.equals("GridWidth")) {
            this.m_gridWidth = Integer.parseInt(string2);
        } else if (string.equals("GridHeight")) {
            this.m_gridHeight = Integer.parseInt(string2);
        } else if (string.equals("GridValues")) {
            this.m_gridString = string2;
        } else if (string.equals("GridShadow")) {
            this.m_shadowWidth = Integer.parseInt(string2);
        } else if (string.equals("GridChecksum") || string.equals("Checksum")) {
            this.m_gridChecksum = Integer.parseInt(string2);
        } else if (string.equals("GridBackgroundColor")) {
            try {
                this.m_gridBackgroundColor = Color.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.m_gridBackgroundColor = this.m_puzzleBackgroundColor;
            }
        } else {
            super.parseAttribute(string, string2);
        }
    }

    boolean registered() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.m_gridString.length(); ++i) {
            char c = this.m_gridString.charAt(i);
            n += c;
            n2 = n2 << 31 | n2 >>> 1;
            n2 ^= c;
        }
        n2 = n ^ n2 ^ 0xAAF0AAF0;
        if ((n2 &= Integer.MAX_VALUE) == this.m_gridChecksum) {
            bl = true;
        }
        return bl;
    }

    abstract class PuzzleGridPanel
    extends Puzzle.PuzzlePanel {
        int m_gridCellSize;
        int m_centerX;
        int m_centerY;

        PuzzleGridPanel() {
            super(PuzzleGrid.this);
        }

        public int convertX(int n) {
            n = this.m_gridCellSize > 0 ? (n - this.m_centerX) / this.m_gridCellSize : 0;
            return n;
        }

        public int convertY(int n) {
            n = this.m_gridCellSize > 0 ? (n - this.m_centerY) / this.m_gridCellSize : 0;
            return n;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            int n = PuzzleGrid.this.m_gridWidth > 0 ? (int)(0.95 * (double)this.m_width - (double)PuzzleGrid.this.m_shadowWidth) / PuzzleGrid.this.m_gridWidth : 0;
            int n2 = PuzzleGrid.this.m_gridHeight > 0 ? (int)(0.95 * (double)this.m_height - (double)PuzzleGrid.this.m_shadowWidth) / PuzzleGrid.this.m_gridHeight : 0;
            this.m_gridCellSize = n < n2 ? n : n2;
            this.m_centerX = (this.m_width - this.m_gridCellSize * PuzzleGrid.this.m_gridWidth) / 2;
            this.m_centerY = (this.m_height - this.m_gridCellSize * PuzzleGrid.this.m_gridHeight) / 2;
        }
    }

    class PuzzleGridCell
    extends Puzzle.PuzzleCharacter {
        GridStatus m_gridStatus;

        PuzzleGridCell(PuzzleGrid puzzleGrid, char c, GridStatus gridStatus) {
            super(puzzleGrid, c);
            this.m_gridStatus = gridStatus;
        }

        GridStatus gridStatus() {
            return this.m_gridStatus;
        }
    }
}

